<?php
session_start();
header('Content-Type: application/json');

if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    echo json_encode(['eligible' => false]);
    exit;
}

$type = isset($_GET['type']) ? $_GET['type'] : ''; // 'challenge' or 'bonus'
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$user_id = $_SESSION['user_id'];

if ($type !== 'challenge' && $type !== 'bonus' || $id <= 0) {
    echo json_encode(['eligible' => false]);
    exit;
}

require_once "../config.php";

$eligible = false;

// Check if already claimed
$table = ($type === 'challenge') ? 'user_challenges' : 'user_bonuses';
$stmt = $conn->prepare("SELECT 1 FROM $table WHERE user_id = ? AND {$type}_id = ?");
$stmt->bind_param("ii", $user_id, $id);
$stmt->execute();
$result = $stmt->get_result();
if ($result->num_rows > 0) {
    echo json_encode(['eligible' => false, 'claimed' => true]);
    $stmt->close();
    $conn->close();
    exit;
}
$stmt->close();

// Placeholder criteria check (customize!)
if ($type === 'challenge') {
    // Example for challenge ID 1: Check playtime
    $eligible = true; // Replace with real logic
} elseif ($type === 'bonus') {
    $eligible = true; // Replace with real logic, e.g., check deposits
}

echo json_encode(['eligible' => $eligible]);

$conn->close();
?>
