<?php
session_start();
header('Content-Type: application/json');

$response = ['success' => false, 'message' => 'An error occurred.'];

if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    $response['message'] = 'You must be logged in to claim.';
    echo json_encode($response);
    exit;
}

$challenge_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$user_id = $_SESSION['user_id']; // Adjust based on your session

if ($challenge_id <= 0) {
    $response['message'] = 'Invalid challenge ID.';
    echo json_encode($response);
    exit;
}

require_once "../config.php";

// Check if already claimed
$stmt = $conn->prepare("SELECT status FROM user_challenges WHERE user_id = ? AND challenge_id = ?");
$stmt->bind_param("ii", $user_id, $challenge_id);
$stmt->execute();
$result = $stmt->get_result();
if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    if ($row['status'] === 'claimed') {
        $response['message'] = 'Already claimed.';
        echo json_encode($response);
        $stmt->close();
        $conn->close();
        exit;
    }
}
$stmt->close();

// Placeholder for criteria check (customize this!)
$criteria_met = false; // Replace with real check, e.g., query playtime from a logs table
// Example: if ($challenge_id == 1) { $criteria_met = (getUserPlaytime($user_id) >= 10); }

if (!$criteria_met) {
    $response['message'] = 'Please complete the challenge first (e.g., play for 10 minutes) before claiming.';
    echo json_encode($response);
    $conn->close();
    exit;
}

// Fetch reward and proceed with claim (rest same as before)
$stmt = $conn->prepare("SELECT reward FROM challenges WHERE id = ?");
$stmt->bind_param("i", $challenge_id);
$stmt->execute();
$result = $stmt->get_result();
$challenge = $result->fetch_assoc();
$reward = $challenge['reward'];
$stmt->close();

// Update balance and mark claimed
$conn->begin_transaction();
try {
    $stmt = $conn->prepare("INSERT INTO user_challenges (user_id, challenge_id, status) VALUES (?, ?, 'claimed') ON DUPLICATE KEY UPDATE status = 'claimed'");
    $stmt->bind_param("ii", $user_id, $challenge_id);
    $stmt->execute();
    $stmt->close();

    $stmt = $conn->prepare("UPDATE users SET balance = balance + ? WHERE id = ?");
    $stmt->bind_param("di", $reward, $user_id);
    $stmt->execute();
    $stmt->close();

    $conn->commit();
    $response['success'] = true;
    $response['message'] = 'Claim successful! ₹' . number_format($reward, 2) . ' added to your balance.';
} catch (Exception $e) {
    $conn->rollback();
    $response['message'] = 'Failed to claim. Try again.';
}

$conn->close();
echo json_encode($response);
?>
