<?php
// Initialize the session
session_start([
  'cookie_httponly' => true,
  'cookie_secure' => true,
  'use_strict_mode' => true
]);
 
// Check if the user is logged in, if not then redirect to login page
if(!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true){
    header("location: login");
    exit;
}
require_once "../config.php";

// Helper function for SQL sum queries
function fetchSum($conn, $query, $params) {
    $stmt = $conn->prepare($query);
    if ($stmt === false) return 0;
    $types = str_repeat('s', count($params));
    $stmt->bind_param($types, ...$params);
    $stmt->execute();
    $result = $stmt->get_result();
    $sum = $result->fetch_assoc();
    $stmt->close();
    return ($sum['total'] == "") ? 0 : round($sum['total'], 2);
}

// Get balance
$balance = fetchSum($conn, "SELECT balance as total FROM users WHERE username=?", [$_SESSION['username']]);

// Get bonus summary by type
$summaryQuery = "SELECT type, SUM(amount) as total FROM `bonus` WHERE usercode='".$_SESSION['usercode']."' GROUP BY type";
$summaryResult = mysqli_query($conn, $summaryQuery);

$summaryHtml = '';
while ($summaryRow = mysqli_fetch_array($summaryResult)) {
    $summaryHtml .= "<div class='bonus-summary-item'>
        <span>{$summaryRow['type']}</span>
        <span>₹".number_format($summaryRow['total'], 2)."</span>
    </div>";
}

// MySQL select query for history
$query1 = "SELECT * FROM `bonus` WHERE usercode='".$_SESSION['usercode']."'";
$result1 = mysqli_query($conn, $query1);

$dataRow = "";
$number_of_result = mysqli_num_rows($result1);  
$results_per_page = 10;  

// Determine the total number of pages available  
$number_of_page = ceil($number_of_result / $results_per_page);  

// Determine which page number visitor is currently on  
if (!isset($_GET['page'])) {  
    $page = 1;  
} else {  
    $page = $_GET['page'];  
}  
 
// Determine the sql LIMIT starting number for the results on the displaying page  
$page_first_result = ($page-1) * $results_per_page;  

// Retrieve the selected results from database   
$query = "SELECT * FROM `bonus` WHERE usercode='".$_SESSION['usercode']."' ORDER BY id DESC LIMIT " . $page_first_result . ',' . $results_per_page;  
$result = mysqli_query($conn, $query);  
  
// Display the retrieved result on the webpage  
while ($row2 = mysqli_fetch_array($result)) {  
    $dataRow .= "<tr>
        <td>$row2[1]</td>
        <td>₹".number_format($row2[3], 2)."</td>
        <td>$row2[4]</td>
    </tr>";
}

$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Bonus - Chicken Road</title>
  <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"/>

  <style>
    :root {
      --primary: #fbb034;
      --secondary: #00ffcc;
      --dark-bg: #0c0c0f;
      --card-bg: #131317;
      --highlight: rgba(255, 215, 0, 0.1);
      --text-light: #e0e0e0;
      --text-muted: #aaa;
      --success: #4CAF50;
    }
    
    * {
      box-sizing: border-box;
      margin: 0;
      padding: 0;
    }
    
    body {
      font-family: 'Montserrat', sans-serif;
      background: var(--dark-bg);
      color: var(--text-light);
      margin: 0;
      padding: 80px 0 80px;
      min-height: 100vh;
    }
    
    header {
      display: flex;
      justify-content: space-between;
      align-items: center;
      padding: 15px 20px;
      background: linear-gradient(135deg, rgba(30,30,35,0.95) 0%, rgba(20,20,25,0.95) 100%);
      backdrop-filter: blur(10px);
      -webkit-backdrop-filter: blur(10px);
      position: fixed;
      top: 0;
      left: 0;
      right: 0;
      z-index: 1000;
      border-bottom: 1px solid rgba(255,255,255,0.1);
      height: 60px;
      box-shadow: 0 5px 20px rgba(0,0,0,0.3);
    }
    
    .logo { 
      font-size: 1.4rem; 
      font-weight: 700; 
      color: var(--primary);
      text-shadow: 0 0 10px rgba(251, 176, 52, 0.3);
    }
    
    .balance { 
      background: linear-gradient(135deg, rgba(251, 176, 52, 0.2) 0%, rgba(247, 151, 30, 0.2) 100%); 
      border-radius: 20px; 
      color: var(--primary); 
      padding: 8px 16px; 
      display: flex; 
      align-items: center; 
      gap: 8px;
      font-weight: 600;
      box-shadow: 0 2px 10px rgba(0,0,0,0.1);
      border: 1px solid rgba(251, 176, 52, 0.2);
    }
    
    .profile-container { 
      max-width: 600px; 
      margin: 0 auto; 
      padding: 20px;
      animation: fadeIn 0.5s ease-out;
    }
    
    .card {
      background: linear-gradient(135deg, rgba(19,19,23,0.9) 0%, rgba(25,25,30,0.9) 100%);
      border-radius: 16px;
      padding: 20px;
      margin-bottom: 20px;
      box-shadow: 0 10px 20px rgba(0,0,0,0.2);
      border: 1px solid rgba(255,255,255,0.05);
      backdrop-filter: blur(5px);
      -webkit-backdrop-filter: blur(5px);
    }
    
    .card-header {
      display: flex;
      justify-content: space-between;
      align-items: center;
      margin-bottom: 15px;
    }
    
    .card-title {
      font-size: 1.2rem;
      color: var(--primary);
      display: flex;
      align-items: center;
      gap: 10px;
    }
    
    .card-value {
      font-size: 1.3rem;
      font-weight: 700;
      color: var(--secondary);
    }
    
    .bonus-summary {
      display: flex;
      flex-wrap: wrap;
      gap: 10px;
      margin-bottom: 20px;
    }
    
    .bonus-summary-item {
      background: rgba(251, 176, 52, 0.1);
      padding: 10px 15px;
      border-radius: 8px;
      display: flex;
      justify-content: space-between;
      min-width: 120px;
    }
    
    .bonus-summary-item span:last-child {
      color: var(--primary);
      font-weight: 600;
    }
    
    .table-container {
      overflow-x: auto;
      margin-bottom: 20px;
    }
    
    .table {
      width: 100%;
      border-collapse: collapse;
    }
    
    .table th {
      background: var(--card-bg);
      color: var(--primary);
      padding: 12px;
      text-align: left;
      font-weight: 600;
    }
    
    .table td {
      padding: 12px;
      border-bottom: 1px solid rgba(255,255,255,0.05);
    }
    
    .table tr:nth-child(even) {
      background: rgba(255,255,255,0.02);
    }
    
    .pagination {
      display: flex;
      justify-content: space-between;
      align-items: center;
      padding: 15px;
      background: var(--card-bg);
      border-radius: 12px;
    }
    
    .pagination-info {
      font-size: 0.9rem;
      color: var(--text-muted);
    }
    
    .pagination-controls {
      display: flex;
      gap: 10px;
    }
    
    .pagination-btn {
      background: var(--card-bg);
      border: 1px solid rgba(255,255,255,0.1);
      color: var(--text-light);
      padding: 8px 15px;
      border-radius: 8px;
      cursor: pointer;
      transition: all 0.3s ease;
    }
    
    .pagination-btn:hover {
      background: rgba(255,255,255,0.05);
    }
    
    .pagination-btn:disabled {
      opacity: 0.5;
      cursor: not-allowed;
    }
    
    .bottom-nav { 
      position: fixed; 
      bottom: 0; 
      left: 0;
      right: 0;
      background: linear-gradient(135deg, rgba(30,30,35,0.95) 0%, rgba(20,20,25,0.95) 100%); 
      backdrop-filter: blur(10px);
      -webkit-backdrop-filter: blur(10px);
      border-top: 1px solid rgba(255,255,255,0.1); 
      display: flex; 
      justify-content: space-around; 
      height: 70px;
      z-index: 1000;
      box-shadow: 0 -5px 20px rgba(0,0,0,0.3);
    }
    
    .bottom-nav a { 
      flex: 1; 
      text-align: center; 
      color: var(--text-muted); 
      font-size: 0.7rem; 
      text-decoration: none; 
      padding: 12px 0 8px;
      display: flex;
      flex-direction: column;
      align-items: center;
      justify-content: center;
      transition: all 0.2s ease;
    }
    
    .bottom-nav a i {
      font-size: 1.2rem;
      margin-bottom: 5px;
      transition: all 0.2s ease;
    }
    
    .bottom-nav a.active { 
      color: var(--primary);
    }
    
    .bottom-nav a.active i {
      transform: translateY(-5px);
      text-shadow: 0 5px 10px rgba(251, 176, 52, 0.3);
    }
    
    .toast {
      position: fixed;
      top: 50%;
      left: 50%;
      transform: translate(-50%, -50%);
      background: rgba(0,0,0,0.8);
      color: white;
      padding: 15px 25px;
      border-radius: 8px;
      z-index: 2000;
      display: none;
      animation: fadeIn 0.3s;
    }
    
    .toast.show {
      display: block;
    }
    
    @media screen and (max-width: 600px) {
      .profile-container {
        padding: 15px;
      }
      
      .card {
        padding: 15px;
      }
      
      .bonus-summary {
        flex-direction: column;
      }
      
      .bonus-summary-item {
        width: 100%;
      }
      
      .table th, .table td {
        padding: 8px;
        font-size: 0.9rem;
      }
    }
    
    /* Animations */
    @keyframes fadeIn {
      from { opacity: 0; transform: translateY(20px); }
      to { opacity: 1; transform: translateY(0); }
    }
  </style>
</head>
<body>

<header>
  <div class="logo">Chicken Road</div>
  <div class="balance">
    <i class="fas fa-wallet"></i> 
    ₹<span id="balance"><?php echo htmlspecialchars(number_format($balance, 2)); ?></span>
  </div>
</header>

<div class="profile-container">
  <div class="card animate__animated animate__fadeIn">
    <div class="card-header">
      <div class="card-title">
        <i class="fas fa-gift"></i>
        Bonus Summary
      </div>
    </div>
    <div class="bonus-summary">
      <?php echo $summaryHtml; ?>
    </div>
  </div>
  
  <div class="card animate__animated animate__fadeIn">
    <div class="card-header">
      <div class="card-title">
        <i class="fas fa-history"></i>
        Bonus History
      </div>
    </div>
    
    <div class="table-container">
      <table class="table">
        <thead>
          <tr>
            <th>Username</th>
            <th>Amount</th>
            <th>Type</th>
          </tr>
        </thead>
        <tbody>
          <?php echo $dataRow; ?>
        </tbody>
      </table>
    </div>
    
    <div class="pagination">
      <div class="pagination-info">
        Showing <?php echo (1+($page-1)*10).'-'.min($page*10, $number_of_result); ?> of <?php echo $number_of_result; ?>
      </div>
      <div class="pagination-controls">
        <button class="pagination-btn" onclick="prevPage()" <?php echo $page == 1 ? 'disabled' : ''; ?>>
          <i class="fas fa-chevron-left"></i>
        </button>
        <button class="pagination-btn" onclick="nextPage()" <?php echo $page*10 >= $number_of_result ? 'disabled' : ''; ?>>
          <i class="fas fa-chevron-right"></i>
        </button>
      </div>
    </div>
  </div>
</div>

<nav class="bottom-nav">
  <a href="/home"><i class="fas fa-gamepad"></i>Games</a>
  <a href="/game/invite"><i class="fas fa-user-friends"></i>Invite</a>
  <a href="/game/wallet"><i class="fas fa-wallet"></i>Wallet</a>
  <a href="/game/profile" class="active"><i class="fas fa-user"></i>Account</a>
</nav>

<div id="toast" class="toast">
  <div class="toast-text">Link copied successfully!</div>
</div>

<script>
  // Pagination controls
  function prevPage() {
    let newPage = <?php echo $page; ?> - 1;
    window.location.href = `/game/bonus?page=${newPage}`;
  }
  
  function nextPage() {
    let newPage = <?php echo $page; ?> + 1;
    window.location.href = `/game/bonus?page=${newPage}`;
  }

  // Balance update animation
  function animateBalanceUpdate(oldVal, newVal) {
    const balanceElement = document.getElementById('balance');
    const duration = 1000;
    const start = parseFloat(oldVal.replace(/,/g, ''));
    const end = parseFloat(newVal.replace(/,/g, ''));
    const startTime = performance.now();
    
    function updateBalance(timestamp) {
      const progress = Math.min((timestamp - startTime) / duration, 1);
      const currentValue = start + (end - start) * progress;
      balanceElement.textContent = currentValue.toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ",");
      
      if (progress < 1) {
        requestAnimationFrame(updateBalance);
      }
    }
    
    requestAnimationFrame(updateBalance);
  }

  // Auto update balance
  setInterval(() => {
    fetch('/balance.php', { credentials: 'same-origin' })
      .then(r => r.json())
      .then(d => {
        if (d.balance !== undefined) {
          const currentBalance = document.getElementById('balance').textContent;
          const newBalance = parseFloat(d.balance).toFixed(2);
          if (currentBalance !== newBalance) {
            animateBalanceUpdate(currentBalance, newBalance);
          }
        }
      })
      .catch(err => console.error('Error fetching balance:', err));
  }, 10000);
</script>
</body>
</html>