<?php
session_start([
  'cookie_httponly' => true,
  'cookie_secure' => true,
  'use_strict_mode' => true
]);

if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    header("location: login");
    exit;
}

require_once "../config.php";

// Helper function for SQL sum queries
function fetchSum($conn, $query, $params) {
    $stmt = $conn->prepare($query);
    if ($stmt === false) return 0;
    $types = str_repeat('s', count($params));
    $stmt->bind_param($types, ...$params);
    $stmt->execute();
    $result = $stmt->get_result();
    $sum = $result->fetch_assoc();
    $stmt->close();
    return ($sum['total'] == "") ? 0 : round($sum['total'], 2);
}

$bonus = fetchSum($conn, "SELECT SUM(amount) as total FROM bonus WHERE usercode=?", [$_SESSION['usercode']]);
$bonus1 = fetchSum($conn, "SELECT SUM(amount) as total FROM intrest WHERE username=?", [$_SESSION['username']]);
$balance = fetchSum($conn, "SELECT balance as total FROM users WHERE username=?", [$_SESSION['username']]);
$totalBalance = $balance;
$totalBonus = $bonus;
$totalInterest = $bonus1;

// Fetch level data
$query0 = "SELECT * FROM users WHERE refcode='".$_SESSION['usercode']."'";
$query1 = "SELECT * FROM users WHERE refcode1='".$_SESSION['usercode']."'";
$query2 = "SELECT * FROM users WHERE refcode2='".$_SESSION['usercode']."'";

$result1 = mysqli_query($conn, $query0);
$result3 = mysqli_query($conn, $query1);
$result4 = mysqli_query($conn, $query2);
$rowcount = mysqli_num_rows($result1);
$rowcount2 = mysqli_num_rows($result3);
$rowcount3 = mysqli_num_rows($result4);

// Process level 1 data
$number_of_result = mysqli_num_rows($result1);  
$results_per_page = 10;  
$number_of_page = ceil($number_of_result / $results_per_page);  

if (!isset($_GET['page'])) {  
    $page = 1;  
} else {  
    $page = $_GET['page'];  
}  

$page_first_result = ($page-1) * $results_per_page;  
$query = "SELECT * FROM users WHERE refcode='".$_SESSION['usercode']."' ORDER BY id DESC LIMIT " . $page_first_result . ',' . $results_per_page;  
$result = mysqli_query($conn, $query);  

$dataRow = "";
while ($row2 = mysqli_fetch_array($result)) {  
    $query = "SELECT recharge FROM recharge WHERE username='$row2[1]' AND status='successfull' ORDER BY id ASC";
    $result3 = $conn->query($query);
    $row3 = mysqli_fetch_assoc($result3);
    $amount = $row3['recharge'] ?? 0;

    if($amount == 500) {
        $first = 150;
    } elseif($amount == 1000) {
        $first = 200;
    } elseif($amount == 3000) {
        $first = 400;
    } elseif($amount == 4000) {
        $first = 500;
    } elseif($amount == 5000) {
        $first = 600;
    } elseif($amount == 10000) {
        $first = 1100;
    } elseif($amount == 50000) {
        $first = 5000;
    } elseif($amount == 100000) {
        $first = 10000;
    } else {
        $first = (20/100)*$amount;
    }

    $dataRow .= "<tr>
        <td>$row2[0]</td>
        <td>91$row2[1]</td>
        <td>₹0</td>
        <td>₹$first</td>
    </tr>";
}

// Process level 2 data
$number_of_result1 = mysqli_num_rows($result3);  
$results_per_page1 = 10;  
$number_of_page1 = ceil($number_of_result1 / $results_per_page1);  

if (!isset($_GET['page1'])) {  
    $page1 = 1;  
} else {  
    $page1 = $_GET['page1'];  
}  

$page_first_result1 = ($page1-1) * $results_per_page1;  
$query5 = "SELECT * FROM users WHERE refcode1='".$_SESSION['usercode']."' ORDER BY id DESC LIMIT " . $page_first_result1 . ',' . $results_per_page1;  
$result5 = mysqli_query($conn, $query5);  

$dataRow1 = "";
while ($row21 = mysqli_fetch_array($result5)) {
    $query0 = "SELECT recharge FROM recharge WHERE username='$row21[1]' AND status='successfull' ORDER BY id DESC";
    $result3 = $conn->query($query0);
    $row3 = mysqli_fetch_assoc($result3);
    $amount = $row3['recharge'] ?? 0;

    if($amount == 500) {
        $first = 150;
    } elseif($amount == 1000) {
        $first = 200;
    } elseif($amount == 3000) {
        $first = 400;
    } elseif($amount == 4000) {
        $first = 500;
    } elseif($amount == 5000) {
        $first = 600;
    } elseif($amount == 10000) {
        $first = 1100;
    } elseif($amount == 50000) {
        $first = 5000;
    } elseif($amount == 100000) {
        $first = 10000;
    } else {
        $first = (20/100)*$amount;
    }

    $dataRow1 .= "<tr>
        <td>$row21[0]</td>
        <td>91$row21[1]</td>
        <td>₹0</td>
        <td>₹$first</td>
    </tr>";
}

// Process level 3 data
$number_of_result2 = mysqli_num_rows($result4);  
$results_per_page2 = 10;  
$number_of_page2 = ceil($number_of_result2 / $results_per_page2);  

if (!isset($_GET['page2'])) {  
    $page2 = 1;  
} else {  
    $page2 = $_GET['page2'];  
}  

$page_first_result2 = ($page2-1) * $results_per_page2;  
$query6 = "SELECT * FROM users WHERE refcode2='".$_SESSION['usercode']."' ORDER BY id DESC LIMIT " . $page_first_result2 . ',' . $results_per_page2;  
$result6 = mysqli_query($conn, $query6);  

$dataRow2 = "";
while ($row22 = mysqli_fetch_array($result6)) {  
    $query0 = "SELECT recharge FROM recharge WHERE username='$row22[1]' AND status='successfull' ORDER BY id DESC";
    $result3 = $conn->query($query0);
    $row3 = mysqli_fetch_assoc($result3);
    $amount = $row3['recharge'] ?? 0;

    if($amount == 500) {
        $first = 150;
    } elseif($amount == 1000) {
        $first = 200;
    } elseif($amount == 3000) {
        $first = 400;
    } elseif($amount == 4000) {
        $first = 500;
    } elseif($amount == 5000) {
        $first = 600;
    } elseif($amount == 10000) {
        $first = 1100;
    } elseif($amount == 50000) {
        $first = 5000;
    } elseif($amount == 100000) {
        $first = 10000;
    } else {
        $first = (20/100)*$amount;
    }

    $dataRow2 .= "<tr>
        <td>$row22[0]</td>
        <td>91$row22[1]</td>
        <td>₹0</td>
        <td>₹$first</td>
    </tr>";
}

$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Promotion - Chicken Road</title>
  <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"/>

  <style>
    :root {
      --primary: #fbb034;
      --secondary: #00ffcc;
      --dark-bg: #0c0c0f;
      --card-bg: #131317;
      --highlight: rgba(255, 215, 0, 0.1);
      --text-light: #e0e0e0;
      --text-muted: #aaa;
      --success: #4CAF50;
    }
    
    * {
      box-sizing: border-box;
      margin: 0;
      padding: 0;
    }
    
    body {
      font-family: 'Montserrat', sans-serif;
      background: var(--dark-bg);
      color: var(--text-light);
      margin: 0;
      padding: 80px 0 80px;
      min-height: 100vh;
    }
    
    header {
      display: flex;
      justify-content: space-between;
      align-items: center;
      padding: 15px 20px;
      background: linear-gradient(135deg, rgba(30,30,35,0.95) 0%, rgba(20,20,25,0.95) 100%);
      backdrop-filter: blur(10px);
      -webkit-backdrop-filter: blur(10px);
      position: fixed;
      top: 0;
      left: 0;
      right: 0;
      z-index: 1000;
      border-bottom: 1px solid rgba(255,255,255,0.1);
      height: 60px;
      box-shadow: 0 5px 20px rgba(0,0,0,0.3);
    }
    
    .logo { 
      font-size: 1.4rem; 
      font-weight: 700; 
      color: var(--primary);
      text-shadow: 0 0 10px rgba(251, 176, 52, 0.3);
    }
    
    .balance { 
      background: linear-gradient(135deg, rgba(251, 176, 52, 0.2) 0%, rgba(247, 151, 30, 0.2) 100%); 
      border-radius: 20px; 
      color: var(--primary); 
      padding: 8px 16px; 
      display: flex; 
      align-items: center; 
      gap: 8px;
      font-weight: 600;
      box-shadow: 0 2px 10px rgba(0,0,0,0.1);
      border: 1px solid rgba(251, 176, 52, 0.2);
    }
    
    .profile-container { 
      max-width: 600px; 
      margin: 0 auto; 
      padding: 20px;
      animation: fadeIn 0.5s ease-out;
    }
    
    .card {
      background: linear-gradient(135deg, rgba(19,19,23,0.9) 0%, rgba(25,25,30,0.9) 100%);
      border-radius: 16px;
      padding: 20px;
      margin-bottom: 20px;
      box-shadow: 0 10px 20px rgba(0,0,0,0.2);
      border: 1px solid rgba(255,255,255,0.05);
      backdrop-filter: blur(5px);
      -webkit-backdrop-filter: blur(5px);
    }
    
    .card-header {
      display: flex;
      justify-content: space-between;
      align-items: center;
      margin-bottom: 15px;
    }
    
    .card-title {
      font-size: 1.2rem;
      color: var(--primary);
      display: flex;
      align-items: center;
      gap: 10px;
    }
    
    .card-value {
      font-size: 1.3rem;
      font-weight: 700;
      color: var(--secondary);
    }
    
    .stats-grid {
      display: grid;
      grid-template-columns: repeat(2, 1fr);
      gap: 15px;
      margin-bottom: 20px;
    }
    
    .stat-item {
      background: rgba(255,255,255,0.03);
      border-radius: 12px;
      padding: 15px;
      text-align: center;
    }
    
    .stat-label {
      font-size: 0.85rem;
      color: var(--text-muted);
      margin-bottom: 5px;
    }
    
    .stat-value {
      font-size: 1.1rem;
      font-weight: 600;
      color: var(--text-light);
    }
    
    .promo-code {
      background: rgba(0, 255, 204, 0.1);
      border-radius: 8px;
      padding: 15px;
      margin-bottom: 15px;
      text-align: center;
    }
    
    .promo-label {
      font-size: 0.9rem;
      color: var(--text-muted);
      margin-bottom: 5px;
    }
    
    .promo-value {
      font-size: 1.2rem;
      font-weight: 700;
      color: var(--secondary);
      word-break: break-all;
    }
    
    .btn {
      width: 100%;
      padding: 14px;
      border-radius: 30px;
      font-weight: 600;
      font-size: 1rem;
      text-transform: uppercase;
      letter-spacing: 0.5px;
      cursor: pointer;
      transition: all 0.3s ease;
      text-align: center;
      display: block;
    }
    
    .btn-primary {
      background: var(--primary);
      color: #111;
      border: none;
    }
    
    .btn-primary:hover {
      background: #f7971e;
      transform: translateY(-2px);
      box-shadow: 0 5px 15px rgba(247, 151, 30, 0.3);
    }
    
    .btn-secondary {
      background: transparent;
      color: var(--secondary);
      border: 2px solid var(--secondary);
    }
    
    .btn-secondary:hover {
      background: rgba(0, 255, 204, 0.1);
      transform: translateY(-2px);
    }
    
    .tabs {
      display: flex;
      background: var(--card-bg);
      border-radius: 12px;
      overflow: hidden;
      margin-bottom: 20px;
    }
    
    .tab {
      flex: 1;
      padding: 15px;
      text-align: center;
      cursor: pointer;
      transition: all 0.3s ease;
      font-weight: 600;
    }
    
    .tab.active {
      background: var(--primary);
      color: #111;
    }
    
    .table-container {
      overflow-x: auto;
    }
    
    .table {
      width: 100%;
      border-collapse: collapse;
    }
    
    .table th {
      background: var(--card-bg);
      color: var(--primary);
      padding: 12px;
      text-align: left;
      font-weight: 600;
    }
    
    .table td {
      padding: 12px;
      border-bottom: 1px solid rgba(255,255,255,0.05);
    }
    
    .table tr:nth-child(even) {
      background: rgba(255,255,255,0.02);
    }
    
    .pagination {
      display: flex;
      justify-content: space-between;
      align-items: center;
      padding: 15px;
      background: var(--card-bg);
      border-radius: 12px;
    }
    
    .pagination-info {
      font-size: 0.9rem;
      color: var(--text-muted);
    }
    
    .pagination-controls {
      display: flex;
      gap: 10px;
    }
    
    .pagination-btn {
      background: var(--card-bg);
      border: 1px solid rgba(255,255,255,0.1);
      color: var(--text-light);
      padding: 8px 15px;
      border-radius: 8px;
      cursor: pointer;
      transition: all 0.3s ease;
    }
    
    .pagination-btn:hover {
      background: rgba(255,255,255,0.05);
    }
    
    .pagination-btn:disabled {
      opacity: 0.5;
      cursor: not-allowed;
    }
    
    .bottom-nav { 
      position: fixed; 
      bottom: 0; 
      left: 0;
      right: 0;
      background: linear-gradient(135deg, rgba(30,30,35,0.95) 0%, rgba(20,20,25,0.95) 100%); 
      backdrop-filter: blur(10px);
      -webkit-backdrop-filter: blur(10px);
      border-top: 1px solid rgba(255,255,255,0.1); 
      display: flex; 
      justify-content: space-around; 
      height: 70px;
      z-index: 1000;
      box-shadow: 0 -5px 20px rgba(0,0,0,0.3);
    }
    
    .bottom-nav a { 
      flex: 1; 
      text-align: center; 
      color: var(--text-muted); 
      font-size: 0.7rem; 
      text-decoration: none; 
      padding: 12px 0 8px;
      display: flex;
      flex-direction: column;
      align-items: center;
      justify-content: center;
      transition: all 0.2s ease;
    }
    
    .bottom-nav a i {
      font-size: 1.2rem;
      margin-bottom: 5px;
      transition: all 0.2s ease;
    }
    
    .bottom-nav a.active { 
      color: var(--primary);
    }
    
    .bottom-nav a.active i {
      transform: translateY(-5px);
      text-shadow: 0 5px 10px rgba(251, 176, 52, 0.3);
    }
    
    .toast {
      position: fixed;
      top: 50%;
      left: 50%;
      transform: translate(-50%, -50%);
      background: rgba(0,0,0,0.8);
      color: white;
      padding: 15px 25px;
      border-radius: 8px;
      z-index: 2000;
      display: none;
      animation: fadeIn 0.3s;
    }
    
    .toast.show {
      display: block;
    }
    
    @media screen and (max-width: 600px) {
      .profile-container {
        padding: 15px;
      }
      
      .stats-grid {
        grid-template-columns: 1fr;
      }
      
      .card {
        padding: 15px;
      }
      
      .table th, .table td {
        padding: 8px;
        font-size: 0.9rem;
      }
    }
    
    /* Animations */
    @keyframes fadeIn {
      from { opacity: 0; transform: translateY(20px); }
      to { opacity: 1; transform: translateY(0); }
    }
  </style>
</head>
<body>

<header>
  <div class="logo">Chicken Road</div>
  <div class="balance">
    <i class="fas fa-wallet"></i> 
    ₹<span id="balance"><?php echo htmlspecialchars(number_format($balance, 2)); ?></span>
  </div>
</header>

<div class="profile-container">
  <div class="card animate__animated animate__fadeIn">
    <div class="card-header">
      <div class="card-title">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" width="24" height="24">
          <path fill-rule="evenodd" d="M12 2.25c-5.385 0-9.75 4.365-9.75 9.75s4.365 9.75 9.75 9.75 9.75-4.365 9.75-9.75S17.385 2.25 12 2.25ZM9 7.5A.75.75 0 0 0 9 9h1.5c.98 0 1.813.626 2.122 1.5H9A.75.75 0 0 0 9 12h3.622a2.251 2.251 0 0 1-2.122 1.5H9a.75.75 0 0 0-.53 1.28l3 3a.75.75 0 1 0 1.06-1.06L10.8 14.988A3.752 3.752 0 0 0 14.175 12H15a.75.75 0 0 0 0-1.5h-.825A3.733 3.733 0 0 0 13.5 9H15a.75.75 0 0 0 0-1.5H9Z" clip-rule="evenodd" />
        </svg>
        Bonus Balance
      </div>
      <div class="card-value">₹<?php echo htmlspecialchars($bonus); ?></div>
    </div>
    
    <div class="stats-grid">
      <div class="stat-item">
        <div class="stat-label">Total People</div>
        <div class="stat-value"><?php echo ($rowcount+$rowcount2+$rowcount3); ?></div>
      </div>
      <div class="stat-item">
        <div class="stat-label">Total Contribution</div>
        <div class="stat-value">₹<?php echo htmlspecialchars($bonus); ?></div>
      </div>
    </div>
    
    <a href="/bonus" class="btn btn-primary">
      <i class="fas fa-gift"></i> Claim Rewards
    </a>
  </div>
  
  <div class="card animate__animated animate__fadeIn animate__delay-1s">
    <div class="promo-code">
      <div class="promo-label">My Promotion Code</div>
      <div class="promo-value"><?php echo htmlspecialchars($_SESSION['usercode']); ?></div>
    </div>
    
    <div class="promo-code">
      <div class="promo-label">My Promotion Link</div>
      <div class="promo-value" id="link">https://tiranga.novasofttech.in/game/register?r_code=<?php echo htmlspecialchars($_SESSION['usercode']); ?></div>
    </div>
    
    <button onclick="copyToClipboard()" class="btn btn-secondary">
      <i class="fas fa-copy"></i> Copy Link
    </button>
  </div>
  
  <div class="tabs animate__animated animate__fadeIn animate__delay-1s">
    <div class="tab active" onclick="showTab(1)">Level 1 (<?php echo $rowcount; ?>)</div>
    <div class="tab" onclick="showTab(2)">Level 2 (<?php echo $rowcount2; ?>)</div>
    <div class="tab" onclick="showTab(3)">Level 3 (<?php echo $rowcount3; ?>)</div>
  </div>
  
  <div class="table-container animate__animated animate__fadeIn animate__delay-1s">
    <table class="table">
      <thead>
        <tr>
          <th>ID</th>
          <th>Phone</th>
          <th>Water Reward</th>
          <th>First Reward</th>
        </tr>
      </thead>
      <tbody id="level1-content">
        <?php echo $dataRow; ?>
      </tbody>
      <tbody id="level2-content" style="display:none;">
        <?php echo $dataRow1; ?>
      </tbody>
      <tbody id="level3-content" style="display:none;">
        <?php echo $dataRow2; ?>
      </tbody>
    </table>
    
    <div class="pagination">
      <div class="pagination-info" id="pagination-info">
        Showing <?php echo (1+($page-1)*10).'-'.min($page*10, $number_of_result); ?> of <?php echo $number_of_result; ?>
      </div>
      <div class="pagination-controls">
        <button class="pagination-btn" onclick="prevPage()" <?php echo $page == 1 ? 'disabled' : ''; ?>>
          <i class="fas fa-chevron-left"></i>
        </button>
        <button class="pagination-btn" onclick="nextPage()" <?php echo $page*10 >= $number_of_result ? 'disabled' : ''; ?>>
          <i class="fas fa-chevron-right"></i>
        </button>
      </div>
    </div>
  </div>
</div>

<nav class="bottom-nav">
  <a href="/home"><i class="fas fa-gamepad"></i>Games</a>
  <a href="/game/invite" class="active"><i class="fas fa-user-friends"></i>Invite</a>
  <a href="/game/wallet"><i class="fas fa-wallet"></i>Wallet</a>
  <a href="/game/profile"><i class="fas fa-user"></i>Account</a>
</nav>

<div id="toast" class="toast">
  <div class="toast-text">Link copied successfully!</div>
</div>

<script>
  // Current active tab
let activeTab = 1;

// Tab switching
function showTab(level) {
  // Update active tab
  activeTab = level;
  
  // Update tab styling
  document.querySelectorAll('.tab').forEach(tab => tab.classList.remove('active'));
  document.querySelectorAll('.tab')[level-1].classList.add('active');
  
  // Hide all content
  document.getElementById('level1-content').style.display = 'none';
  document.getElementById('level2-content').style.display = 'none';
  document.getElementById('level3-content').style.display = 'none';
  
  // Show selected content
  document.getElementById('level' + level + '-content').style.display = 'table-row-group';
  
  // Update pagination info
  updatePaginationInfo();
}

function updatePaginationInfo() {
  let page, total, resultsPerPage;
  if(activeTab == 1) {
    page = <?php echo $page; ?>;
    total = <?php echo $number_of_result; ?>;
    resultsPerPage = <?php echo $results_per_page; ?>;
  } else if(activeTab == 2) {
    page = <?php echo $page1; ?>;
    total = <?php echo $number_of_result1; ?>;
    resultsPerPage = <?php echo $results_per_page1; ?>;
  } else {
    page = <?php echo $page2; ?>;
    total = <?php echo $number_of_result2; ?>;
    resultsPerPage = <?php echo $results_per_page2; ?>;
  }
  
  const from = (1+(page-1)*resultsPerPage);
  const to = Math.min(page*resultsPerPage, total);
  document.getElementById('pagination-info').textContent = `Showing ${from}-${to} of ${total}`;
  
  // Update pagination buttons
  const prevBtn = document.querySelector('.pagination-controls button:first-child');
  const nextBtn = document.querySelector('.pagination-controls button:last-child');
  
  prevBtn.disabled = page == 1;
  nextBtn.disabled = page*resultsPerPage >= total;
}

// Pagination controls
function prevPage() {
  let params = new URLSearchParams(window.location.search);
  if(activeTab == 1) {
    params.set('page', <?php echo $page; ?> - 1);
  } else if(activeTab == 2) {
    params.set('page1', <?php echo $page1; ?> - 1);
  } else {
    params.set('page2', <?php echo $page2; ?> - 1);
  }
  window.location.search = params.toString();
}

function nextPage() {
  let params = new URLSearchParams(window.location.search);
  if(activeTab == 1) {
    params.set('page', <?php echo $page; ?> + 1);
  } else if(activeTab == 2) {
    params.set('page1', <?php echo $page1; ?> + 1);
  } else {
    params.set('page2', <?php echo $page2; ?> + 1);
  }
  window.location.search = params.toString();
}

// Initialize the correct tab based on URL parameter
function initTab() {
  const params = new URLSearchParams(window.location.search);
  if(params.has('page1')) {
    showTab(2);
  } else if(params.has('page2')) {
    showTab(3);
  } else {
    showTab(1);
  }
}

// Call initTab when page loads
window.addEventListener('load', initTab);
  
  // Copy to clipboard
  function copyToClipboard() {
    const link = document.getElementById('link').textContent;
    navigator.clipboard.writeText(link).then(() => {
      showToast('Link copied successfully!');
    }).catch(err => {
      showToast('Failed to copy link');
      console.error('Failed to copy: ', err);
    });
  }
  
  function showToast(message) {
    const toast = document.getElementById('toast');
    toast.querySelector('.toast-text').textContent = message;
    toast.classList.add('show');
    
    setTimeout(() => {
      toast.classList.remove('show');
    }, 3000);
  }
  
  // Balance update animation
  function animateBalanceUpdate(oldVal, newVal) {
    const balanceElement = document.getElementById('balance');
    const duration = 1000;
    const start = parseFloat(oldVal.replace(/,/g, ''));
    const end = parseFloat(newVal.replace(/,/g, ''));
    const startTime = performance.now();
    
    function updateBalance(timestamp) {
      const progress = Math.min((timestamp - startTime) / duration, 1);
      const currentValue = start + (end - start) * progress;
      balanceElement.textContent = currentValue.toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ",");
      
      if (progress < 1) {
        requestAnimationFrame(updateBalance);
      }
    }
    
    requestAnimationFrame(updateBalance);
  }

  // Auto update balance
  setInterval(() => {
    fetch('/balance.php', { credentials: 'same-origin' })
      .then(r => r.json())
      .then(d => {
        if (d.balance !== undefined) {
          const currentBalance = document.getElementById('balance').textContent;
          const newBalance = parseFloat(d.balance).toFixed(2);
          if (currentBalance !== newBalance) {
            animateBalanceUpdate(currentBalance, newBalance);
          }
        }
      })
      .catch(err => console.error('Error fetching balance:', err));
  }, 10000);
</script>
</body>
</html>