<?php
session_start();

if (isset($_SESSION["loggedin"])) {
    header("location: me");
    exit;
}

require_once "../config.php";

$username = $password = "";
$err = "";

if ($_SERVER['REQUEST_METHOD'] == "POST") {
    if (empty(trim($_POST['username'])) || empty(trim($_POST['password']))) {
        $err = "Please enter username and password";
    } else {
        $username = substr(trim($_POST["username"]), 3);
        $password = trim($_POST['password']);
    }

    if (empty($err)) {
        $res = mysqli_query($conn, "SELECT * FROM users WHERE username='$username' AND password='$password'");
        $result = mysqli_fetch_array($res);
        if ($result) {
            $loginip = getenv("REMOTE_ADDR");
            $sql2 = "SELECT * FROM users WHERE username='$username'";
            $result2 = $conn->query($sql2);
            $row2 = mysqli_fetch_assoc($result2);
            $sql3 = "UPDATE users SET ip='$loginip' WHERE username='$username'";
            $conn->query($sql3);

            $_SESSION["username"] = $row2['username'];
            $_SESSION["id"] = $row2['id'];
            $_SESSION["usercode"] = $row2['usercode'];
            $_SESSION["refcode"] = $row2['refcode'];
            $_SESSION["refcode1"] = $row2['refcode1'];
            $_SESSION["refcode2"] = $row2['refcode2'];
            $_SESSION["loggedin"] = true;

            header("location: ../home");
        } else {
            $err = "Incorrect Username or Password";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <!-- Disable zoom in/out on mobile -->
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <title>Login</title>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <style>
    * { box-sizing: border-box; margin: 0; padding: 0; }
    body {
      font-family: 'Inter', sans-serif;
      height: 100vh;
      display: flex;
      justify-content: center;
      align-items: center;
      background: radial-gradient(circle at top, #1a1a1d, #0d0d0d);
      overflow: hidden;
      position: relative;
      color: #fff;
    }

    canvas {
      position: fixed;
      top: 0; left: 0;
      width: 100%; height: 100%;
      z-index: 0;
      pointer-events: none;
    }

    .login-card {
      z-index: 1;
      background: rgba(20,20,22,0.88);
      padding: 40px;
      border-radius: 20px;
      width: 100%; max-width: 420px;
      text-align: center;
      position: relative;
      overflow: hidden;
      animation: fadeIn 1s ease;
    }

    .login-card::before {
      content: "";
      position: absolute;
      inset: 0;
      padding: 2px;
      border-radius: 20px;
      background: linear-gradient(120deg, #f7b731, #e09e28, #c88512, #f7b731);
      background-size: 300% 300%;
      animation: shine 6s linear infinite;
      -webkit-mask: linear-gradient(#000 0 0) content-box, linear-gradient(#000 0 0);
      -webkit-mask-composite: xor;
              mask-composite: exclude;
      pointer-events: none;
    }
    @keyframes shine {
      0%{ background-position:0% 50%;}
      50%{ background-position:100% 50%;}
      100%{ background-position:0% 50%;}
    }

    .logo {
      width: 90px; margin: 0 auto 20px auto;
      animation: float 3s ease-in-out infinite;
    }
    @keyframes float {
      0%{ transform: translateY(0);}
      50%{ transform: translateY(-12px);}
      100%{ transform: translateY(0);}
    }

    .login-card h2 {
      font-size: 28px;
      margin-bottom: 25px;
      color: #f7b731;
      text-shadow: 0 0 10px rgba(247,183,49,0.6);
    }

    .error-msg { color: #ff4d4d; margin-bottom: 15px; font-size: 14px; }

    .input-box {
      position: relative; margin-bottom: 25px;
    }
    .input-box input {
      width: 100%;
      padding: 16px 50px 16px 15px;
      border-radius: 12px;
      border: 1px solid rgba(255,255,255,0.15);
      background: rgba(255,255,255,0.07);
      color: #fff; font-size: 16px;
      transition: all 0.3s;
    }
    .input-box input:focus {
      border-color: #f7b731;
      outline: none;
      box-shadow: 0 0 12px rgba(247,183,49,0.5);
    }
    .input-box label {
      position: absolute; left: 15px; top: 50%;
      transform: translateY(-50%);
      color: #aaa; font-size: 14px;
      pointer-events: none; transition: 0.3s;
    }
    .input-box input:focus + label,
    .input-box input:not(:placeholder-shown) + label {
      top: -8px; left: 10px;
      background: rgba(20,20,22,0.9);
      padding: 0 6px;
      font-size: 12px;
      color: #f7b731;
    }
    .input-box .icon {
      position: absolute; top: 50%; right: 15px;
      transform: translateY(-50%);
      color: #f7b731;
      cursor: pointer;
    }

    .login-btn {
      width: 100%; padding: 14px;
      border: none; border-radius: 12px;
      background: linear-gradient(135deg,#f7b731,#e09e28);
      color: #0d0d0d; font-weight: 700; font-size: 18px;
      cursor: pointer; transition: all 0.3s;
      box-shadow: 0 0 20px rgba(247,183,49,0.4);
    }
    .login-btn:hover {
      transform: translateY(-3px);
      background: linear-gradient(135deg,#e09e28,#c88512);
      box-shadow: 0 0 25px rgba(247,183,49,0.7);
    }

    .extra-links {
      margin-top: 20px;
      display: flex; justify-content: space-between;
      font-size: 14px;
    }
    .extra-links a {
      color: #f7b731; text-decoration: none;
      z-index: 2; position: relative;
    }
    .extra-links a:hover { text-decoration: underline; }

    @keyframes fadeIn {
      from { opacity: 0; transform: translateY(40px);}
      to { opacity: 1; transform: translateY(0);}
    }
  </style>
  <script>
    function validateNumber(input){ input.value = input.value.replace(/[^0-9+]/g,''); }
    function addCountryCode(){ const u=document.getElementById("username"); if(u.value===""){ u.value="+91"; } }
    function togglePassword(){
      const pwd=document.getElementById("password");
      const icon=document.getElementById("toggleIcon");
      if(pwd.type==="password"){ pwd.type="text"; icon.classList.remove("fa-eye"); icon.classList.add("fa-eye-slash"); }
      else { pwd.type="password"; icon.classList.remove("fa-eye-slash"); icon.classList.add("fa-eye"); }
    }

    // Golden Particles Only (Footprints removed)
    window.onload = function(){
      const c=document.querySelector("canvas");
      const ctx=c.getContext("2d");
      c.width=window.innerWidth; c.height=window.innerHeight;

      let particles=[];

      function Particle(x,y){
        this.x=x; this.y=y;
        this.radius=Math.random()*2+1;
        this.speedY=Math.random()*1+0.5;
      }
      Particle.prototype.update=function(){
        this.y -= this.speedY;
        if(this.y<0) this.y=c.height;
      }
      Particle.prototype.draw=function(){
        ctx.beginPath();
        ctx.arc(this.x,this.y,this.radius,0,Math.PI*2);
        ctx.fillStyle="rgba(247,183,49,0.8)";
        ctx.fill();
      }

      // Reduced dots (60 instead of 120)
      for(let i=0;i<10;i++){
        particles.push(new Particle(Math.random()*c.width,Math.random()*c.height));
      }

      function animate(){
        ctx.clearRect(0,0,c.width,c.height);
        particles.forEach(p=>{p.update(); p.draw();});
        requestAnimationFrame(animate);
      }
      animate();

      window.onresize=function(){
        c.width=window.innerWidth; c.height=window.innerHeight;
      }
    }
  </script>
</head>
<body>
  <canvas></canvas>

  <div class="login-card">
    <img src="/img/logo.png" alt="Chicken Logo" class="logo">
    <h2>Login</h2>

    <?php if (!empty($err)): ?>
      <div class="error-msg"><?php echo $err; ?></div>
    <?php endif; ?>

    <form action="" method="POST">
      <div class="input-box">
        <input type="text" id="username" name="username" placeholder=" " onclick="addCountryCode()" oninput="validateNumber(this)" required>
        <label for="username">Mobile Number</label>
        <i class="fas fa-user icon"></i>
      </div>

      <div class="input-box">
        <input type="password" id="password" name="password" placeholder=" " required>
        <label for="password">Password</label>
        <i id="toggleIcon" class="fas fa-eye icon" onclick="togglePassword()" style="cursor:pointer;"></i>
      </div>

      <button type="submit" class="login-btn">Login</button>
    </form>

    <div class="extra-links">
      <a href="/game/register">Register</a>
      <a href="/game/forgot_pass">Forgot Password?</a>
    </div>
  </div>
</body>
</html>
