<?php
session_start();
if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    header("Location: login.php");
    exit;
}
require_once "../config.php";

$userId = $_SESSION['id'];

// Clear all notifications for this user
if (isset($_GET['clear']) && $_GET['clear'] == 'all') {
    $conn->query("DELETE FROM notifications WHERE user_id = $userId OR user_id IS NULL");
    header("Location: notification.php");
    exit;
}

// Fetch all notifications (both user-specific and global admin, sorted latest first)
$sql = "SELECT * FROM notifications 
        WHERE user_id = $userId OR user_id IS NULL
        ORDER BY created_at DESC";
$result = $conn->query($sql);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Notifications</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <style>
        body {
            font-family: 'Montserrat', sans-serif;
            background: #0c0c0f;
            color: #e0e0e0;
            padding: 60px 20px 80px; /* top padding adjusted for header */
            margin: 0;
        }
        .header {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            height: 55px;
            display: flex;
            align-items: center;
            background: rgba(19,19,23,0.95);
            border-bottom: 1px solid rgba(255,255,255,0.1);
            padding: 0 15px;
            z-index: 1000;
        }
        .header a {
            color: #fbb034;
            text-decoration: none;
            font-size: 1rem;
            display: flex;
            align-items: center;
        }
        .header a i {
            margin-right: 8px;
            font-size: 1.2rem;
        }
        .container {
            max-width: 600px;
            margin: auto;
        }
        h1 {
            color: #fbb034;
            text-align: center;
            margin-bottom: 20px;
        }
        .notification {
            background: #131317;
            padding: 15px;
            border-radius: 10px;
            margin-bottom: 10px;
            border: 1px solid rgba(251, 176, 52, 0.1);
            display: flex;
            gap: 12px;
        }
        .notif-icon {
            font-size: 1.4rem;
            color: #fbb034;
        }
        .notif-content {
            flex: 1;
        }
        .notif-title {
            font-weight: 600;
            margin-bottom: 5px;
            color: #fff;
        }
        .notif-time {
            font-size: 0.75rem;
            color: #aaa;
        }
        .clear-btn {
            display: block;
            text-align: center;
            padding: 10px;
            background: rgba(251, 176, 52, 0.1);
            border: 1px solid rgba(251, 176, 52, 0.2);
            border-radius: 8px;
            color: #fbb034;
            text-decoration: none;
            font-weight: 600;
            margin-top: 20px;
        }
        .clear-btn:hover {
            background: rgba(251, 176, 52, 0.2);
        }
    </style>
</head>
<body>

<!-- Top Header with Back Button -->
<div class="header">
    <a href="profile.php"><i class="fas fa-arrow-left"></i> Back</a>
</div>

<div class="container">
    <h1>Notifications</h1>

    <?php
    if ($result && $result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $icon = "fa-info-circle";
            if ($row['type'] == 'deposit') $icon = "fa-arrow-down";
            if ($row['type'] == 'withdraw') $icon = "fa-arrow-up";
            if ($row['type'] == 'bonus') $icon = "fa-gift";
            if ($row['type'] == 'system') $icon = "fa-bullhorn";

            echo "<div class='notification'>
                    <i class='notif-icon fas $icon'></i>
                    <div class='notif-content'>
                        <div class='notif-title'>" . htmlspecialchars($row['title']) . "</div>
                        <div class='notif-message'>" . htmlspecialchars($row['message']) . "</div>
                        <div class='notif-time'>" . date('d M Y H:i', strtotime($row['created_at'])) . "</div>
                    </div>
                  </div>";
        }
        echo "<a class='clear-btn' href='?clear=all'><i class='fas fa-trash'></i> Clear All</a>";
    } else {
        echo "<p style='text-align:center;color:#aaa'>No notifications found</p>";
    }
    ?>
</div>

</body>
</html>
