<?php
require_once "../config.php";
session_start();

header('Content-Type: application/json');
$action = $_GET['action'] ?? '';

/* ---------- 1. SEND OTP ---------- */
if ($action === 'send') {
    $num = trim($_POST['mobile'] ?? '');
    if (!preg_match('/^[6-9]\d{9}$/', $num)) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid mobile']);
        exit;
    }

    $otp = rand(100000, 999999);

    // save OTP
    $stmt = $conn->prepare("REPLACE INTO verify (username, otp) VALUES (?, ?)");
    $stmt->bind_param("ss", $num, $otp);
    $stmt->execute();

    // send via Fast2SMS
    $fields = [
        "variables_values" => "$otp",
        "route" => "otp",
        "numbers" => $num,
    ];

    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => "https://www.fast2sms.com/dev/bulkV2",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => json_encode($fields),
        CURLOPT_HTTPHEADER => [
            "authorization: t4rZXEiWfjClNrjJ4WQswpuP7LSOFp1bvvpxfthCRvbqd3SyaO8O2SFIP7dz",
            "content-type: application/json"
        ],
    ]);
    $response = curl_exec($curl);
    $err = curl_error($curl);
    curl_close($curl);

    if ($err) {
        echo json_encode(['status' => 'error', 'message' => 'SMS failed']);
    } else {
        $_SESSION['otp']        = $otp;
        $_SESSION['otp_mobile'] = $num;
        $_SESSION['otp_time']   = time();
        echo json_encode(['status' => 'success', 'message' => 'OTP sent']);
    }
    exit;
}

/* ---------- 2. VERIFY OTP ---------- */
if ($action === 'verify') {
    $num  = trim($_POST['mobile']  ?? '');
    $code = trim($_POST['otp']     ?? '');

    if (!isset($_SESSION['otp']) || $code != $_SESSION['otp']) {
        echo json_encode(['status' => 'error', 'message' => 'Wrong OTP']);
        exit;
    }
    if ($num != $_SESSION['otp_mobile']) {
        echo json_encode(['status' => 'error', 'message' => 'Mobile mismatch']);
        exit;
    }
    if (time() - $_SESSION['otp_time'] > 300) {
        echo json_encode(['status' => 'error', 'message' => 'OTP expired']);
        exit;
    }

    echo json_encode(['status' => 'success', 'message' => 'Verified']);
    exit;
}

/* fallback */
echo json_encode(['status' => 'error', 'message' => 'Invalid request']);
?>