<?php
// Initialize the session
session_start();

// Check if the user is logged in, if not then redirect to login page
if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    header("location: login");
    exit;
}

require_once "../config.php";

if (!$conn) {
    die("Database connection error.");
}

$userQuery = "SELECT balance, profile_image FROM users WHERE username = '" . $_SESSION['username'] . "' LIMIT 1";
$userResult = $conn->query($userQuery);

if (!$userResult) {
    die("Query failed: " . $conn->error);
}

$userRow = $userResult->fetch_assoc();


$totalBalance = ($userRow['balance'] == "") ? 0 : round($userRow['balance'], 2);

// Handle profile image - assign random if not set
$profileImage = $userRow['profile_image'];
if (empty($profileImage) || $profileImage == null) {
    // Generate random profile image number (1-19) for new users
    $randomProfile = rand(1, 19);

    // Update database with the assigned profile image
    $updateProfileQuery = "UPDATE users SET profile_image = '$randomProfile' WHERE username = '" . $_SESSION['username'] . "'";
    $conn->query($updateProfileQuery);

    $profileImage = $randomProfile;
}

$lastLogin = isset($userRow['last_login']) ? $userRow['last_login'] : 'N/A';

// Fetch commission from bonus table
$bonusQuery = "SELECT SUM(amount) as total FROM bonus WHERE usercode='" . $_SESSION['usercode'] . "'";
$bonusResult = $conn->query($bonusQuery);
$bonusRow = $bonusResult->fetch_assoc();
$totalBonus = ($bonusRow['total'] == "") ? 0 : round($bonusRow['total'], 2);

// Fetch interest from intrest table
$interestQuery = "SELECT SUM(amount) as total FROM intrest WHERE username='" . $_SESSION['username'] . "'";
$interestResult = $conn->query($interestQuery);
$interestRow = $interestResult->fetch_assoc();
$totalInterest = ($interestRow['total'] == "") ? 0 : round($interestRow['total'], 2);

// Fetch notice
$sql = "SELECT notice FROM notice WHERE id='1'";
$result = $conn->query($sql);
$row = mysqli_fetch_array($result);
$notice = $row['notice'];
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Account Page</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" />
    <style>
    :root {
      --primary: #fbb034;
      --secondary: #fbb034;
      --dark-bg: #0c0c0f;
      --card-bg: #131317;
      --highlight: rgba(255, 215, 0, 0.1);
      --text-light: #e0e0e0;
      --text-muted: #aaa;
    }

    * { box-sizing: border-box; margin: 0; padding: 0; }
    body {
      font-family: 'Montserrat', sans-serif;
      background: var(--dark-bg);
      color: var(--text-light);
      margin: 0;
      padding: 80px 0 80px;
      min-height: 100vh;
    }

    header {
      display: flex;
      justify-content: space-between;
      align-items: center;
      padding: 15px 20px;
      background: linear-gradient(135deg, rgba(30, 30, 35, 0.95) 0%, rgba(20, 20, 25, 0.95) 100%);
      backdrop-filter: blur(10px);
      -webkit-backdrop-filter: blur(10px);
      position: fixed;
      top: 0;
      left: 0;
      right: 0;
      z-index: 1000;
      border-bottom: 1px solid rgba(255, 255, 255, 0.1);
      height: 60px;
      box-shadow: 0 5px 20px rgba(0, 0, 0, 0.3);
    }

    .logo {
      font-size: 1.4rem;
      font-weight: 700;
      color: var(--primary);
      text-shadow: 0 0 10px rgba(251, 176, 52, 0.3);
    }

    .profile-container {
      max-width: 600px;
      margin: 0 auto;
      padding: 15px;
      animation: fadeIn 0.5s ease-out;
    }

    .profile-header {
      background: linear-gradient(135deg, #1a1a1f 0%, #131317 100%);
      border-radius: 16px;
      padding: 20px;
      margin-bottom: 20px;
      position: relative;
      overflow: hidden;
      border: 1px solid rgba(251, 176, 52, 0.1);
      box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
    }
    .profile-header::before {
      content: '';
      position: absolute;
      top: -50%;
      left: -50%;
      width: 200%;
      height: 200%;
      background: radial-gradient(circle, rgba(251, 176, 52, 0.05) 0%, transparent 70%);
      transform: rotate(30deg);
    }
    .profile-content {
      display: flex;
      align-items: center;
      position: relative;
      z-index: 2;
    }

    .profile-avatar {
      width: 50px;
      height: 50px;
      border-radius: 50%;
      object-fit: cover;
      border: 3px solid rgba(251, 176, 52, 0.3);
      box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
      background: #1a1a1f;
      padding: 5px;
    }
    .profile-info { margin-left: 20px; flex: 1; }
    .profile-name {
      font-size: 1.3rem;
      font-weight: 700;
      color: var(--text-light);
      margin-bottom: 5px;
      display: flex;
      align-items: center;
      gap: 8px;
    }
    .profile-vip {
      background: linear-gradient(135deg, #ffd700 0%, #f7971e 100%);
      color: #000;
      font-size: 0.7rem;
      padding: 2px 8px;
      border-radius: 10px;
      font-weight: 600;
    }
    .profile-details {
      display: flex;
      flex-wrap: wrap;
      gap: 10px;
      margin-top: 8px;
    }
    .profile-detail {
      display: flex;
      align-items: center;
      font-size: 0.8rem;
      color: var(--text-muted);
    }
    .profile-detail i {
      margin-right: 5px;
      color: var(--primary);
      font-size: 0.9rem;
    }
    .profile-actions {
      position: absolute;
      top: 10px;
      right: 10px;
      z-index: 3;
    }
    .edit-profile {
      background: rgba(251, 176, 52, 0.1);
      border: 1px solid rgba(251, 176, 52, 0.2);
      color: var(--primary);
      width: 30px;
      height: 30px;
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      cursor: pointer;
      transition: all 0.3s ease;
    }
    .edit-profile:hover {
      background: rgba(251, 176, 52, 0.2);
      transform: rotate(15deg);
    }

    .balance-summary {
      background: var(--card-bg);
      border-radius: 12px;
      padding: 20px;
      margin-bottom: 20px;
      border: 1px solid rgba(255, 255, 255, 0.08);
      box-shadow: 0 0px 0px rgba(251, 176, 52, 0.1);
    }
    .balance-title {
      display: flex;
      align-items: center;
      justify-content: space-between;
      margin-bottom: 12px;
    }
    .balance-title h3 {
      font-size: 0.85rem;
      color: var(--text-muted);
      font-weight: 600;
      text-transform: uppercase;
      letter-spacing: 0.6px;
    }
    .balance-amount {
      font-size: 1.8rem;
      font-weight: 700;
      color: var(--primary);
      margin-bottom: 18px;
      display: flex;
      align-items: center;
      gap: 10px;
      justify-content: left;
    }
    .refresh-balance {
      color: var(--primary);
      background: none;
      border: none;
      font-size: 0.95rem;
      cursor: pointer;
      transition: all 0.3s ease;
    }
    .refresh-balance:hover {
      transform: rotate(180deg);
    }

    .balance-actions {
      display: grid;
      grid-template-columns: repeat(3, 1fr);
      gap: 12px;
      margin-top: 15px;
      padding-top: 15px;
      border-top: 1px solid rgba(255, 255, 255, 0.1);
    }
    .balance-action {
      display: flex;
      flex-direction: column;
      align-items: center;
      padding: 12px 8px;
      border-radius: 10px;
      background: rgba(255, 255, 255, 0.05);
      cursor: pointer;
      transition: all 0.3s ease;
      border: 1px solid rgba(255, 255, 255, 0.1);
    }
    .balance-action:hover {
      transform: translateY(-3px);
      background: rgba(251, 176, 52, 0.1);
      border-color: rgba(251, 176, 52, 0.3);
    }
    .balance-icon {
      width: 28px;
      height: 28px;
      margin-bottom: 8px;
    }
    .balance-label {
      font-size: 0.75rem;
      font-weight: 600;
      color: var(--text-light);
      text-align: center;
    }

    .history-section { margin-bottom: 20px; }
    .history-row {
      background: linear-gradient(135deg, rgba(15, 14, 14, 0.9), rgba(31, 31, 35, 0.9));
      border-radius: 12px;
      padding: 15px;
      border: 1px solid rgba(255, 255, 255, 0.04);
    }
    .history-grid {
      display: grid;
      grid-template-columns: repeat(2, 1fr);
      gap: 12px;
    }
    .history-item {
      background: rgba(255, 255, 255, 0.03);
      padding: 12px;
      border-radius: 10px;
      cursor: pointer;
      transition: all 0.3s ease;
      border: 1px solid rgba(255, 255, 255, 0.08);
    }
    .history-item:hover {
      transform: translateY(-2px);
      background: rgba(251, 176, 52, 0.05);
      border-color: rgba(251, 176, 52, 0.2);
    }
    .history-content {
      display: flex;
      align-items: center;
      gap: 10px;
    }
    .history-icon {
      width: 28px;
      height: 28px;
      flex-shrink: 0;
    }
    .history-text h4 {
      margin: 0 0 3px;
      font-size: 0.85rem;
      color: var(--primary);
      font-weight: 600;
    }
    .history-text span {
      font-size: 0.7rem;
      color: var(--text-muted);
    }

    .section-list { margin: 20px 0; }
    .section-list div {
      background: linear-gradient(135deg, rgba(19, 19, 23, 0.9) 0%, rgba(25, 25, 30, 0.9) 100%);
      padding: 15px 20px;
      margin-bottom: 10px;
      border-radius: 12px;
      display: flex;
      justify-content: space-between;
      align-items: center;
      color: var(--text-light);
      font-size: 0.9rem;
      box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
      border: 1px solid rgba(255, 255, 255, 0.05);
      transition: all 0.3s ease;
      cursor: pointer;
    }
    .section-list div:hover {
      background: rgba(255, 255, 255, 0.03);
      transform: translateY(-2px);
    }

    .service-center {
      margin: 20px 0;
      background: linear-gradient(135deg, rgba(19, 19, 23, 0.9) 0%, rgba(25, 25, 30, 0.9) 100%);
      padding: 20px;
      border-radius: 12px;
      box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
      border: 1px solid rgba(255, 255, 255, 0.05);
    }
    .service-center h4 {
      margin-bottom: 20px;
      font-size: 1.1rem;
      color: var(--text-light);
      font-weight: 600;
    }
    .service-grid {
      display: grid;
      grid-template-columns: repeat(3, 1fr);
      gap: 15px;
    }
    .service-item {
      text-align: center;
      color: var(--text-muted);
      font-size: 0.8rem;
      padding: 12px 8px;
      transition: all 0.3s ease;
      cursor: pointer;
      border-radius: 8px;
    }
    .service-item:hover {
      color: var(--text-light);
      background: rgba(255, 255, 255, 0.03);
      transform: translateY(-2px);
    }
    .service-item i {
      font-size: 1.4rem;
      margin-bottom: 8px;
      color: var(--secondary);
    }

    .logout-btn {
      width: 100%;
      margin-top: 30px;
      border: 2px solid var(--secondary);
      color: var(--secondary);
      background: none;
      padding: 14px;
      border-radius: 30px;
      cursor: pointer;
      font-weight: 600;
      font-size: 1rem;
      transition: all 0.3s ease;
      text-transform: uppercase;
      letter-spacing: 0.5px;
      backdrop-filter: blur(5px);
      -webkit-backdrop-filter: blur(5px);
    }
    .logout-btn:hover {
      background: rgba(251, 176, 52, 0.1);
    }


    /* BOTTOM NAVBAR */
    .bottom-nav {
        position: fixed;
        bottom: 0;
        left: 0;
        width: 100%;
        height: 60px;
        backdrop-filter: blur(12px);
        background: rgba(20,20,20,0.7);
        display: flex;
        justify-content: space-around;
        align-items: center;
        border-top: 1px solid rgba(255,255,255,0.1);
        z-index: 100;
    }

    .bottom-nav a {
      flex: 1;
      text-align: center;
      color: var(--text-muted);
      font-size: 0.7rem;
      text-decoration: none;
      padding: 12px 0 8px;
      display: flex;
      flex-direction: column;
      align-items: center;
      justify-content: center;
      transition: all 0.2s ease;
    }
    .bottom-nav a i {
      font-size: 1.2rem;
      margin-bottom: 5px;
      transition: all 0.2s ease;
    }
    .bottom-nav a.active {
      color: var(--primary);
    }
    .bottom-nav a.active i {
      transform: translateY(-5px);
      text-shadow: 0 5px 10px rgba(251, 176, 52, 0.3);
    }

    @media screen and (max-width: 480px) {
      .profile-container { padding: 12px; }
      .profile-header { padding: 15px; }
      .profile-avatar { width: 45px; height: 45px; }
      .profile-name { font-size: 1.1rem; }
      .balance-amount { font-size: 1.6rem; }
      .balance-actions { gap: 8px; }
      .balance-action { padding: 10px 6px; }
      .balance-icon { width: 24px; height: 24px; }
      .balance-label { font-size: 0.7rem; }
      .history-grid { grid-template-columns: 1fr; gap: 8px; }
      .service-grid { grid-template-columns: repeat(2, 1fr); gap: 12px; }
      .service-item { font-size: 0.75rem; padding: 10px 6px; }
      .service-item i { font-size: 1.2rem; }
    }
    @media screen and (max-width: 360px) {
      .balance-label { font-size: 0.65rem; }
      .history-text h4 { font-size: 0.8rem; }
      .history-text span { font-size: 0.65rem; }
    }
    @keyframes fadeIn {
      from { opacity: 0; transform: translateY(20px); }
      to { opacity: 1; transform: translateY(0); }
    }
    </style>
</head>
<body>
<header>
  <div class="logo">Chicken Road</div>
</header>

<div class="profile-container">

  <!-- Profile Header -->
  <div class="profile-header">
    <div class="profile-actions">
      <div class="edit-profile" onclick="window.location.href='editprofile.php'">
        <i class="fas fa-pen"></i>
      </div>
    </div>
    <div class="profile-content">
      <div class="profile-avatar-container" style="position: relative; display: inline-block;">
        <img id="profileImage" src="/images/profile/<?php echo $profileImage; ?>.png" class="profile-avatar" alt="Profile" style="position: relative; z-index: 1;">
      </div>
      <div class="profile-info">
        <div class="profile-name">
          <?php echo htmlspecialchars($_SESSION['username']); ?>
          <span class="profile-vip">VIP</span>
        </div>
        <div class="profile-details">
          <div class="profile-detail">
            <i class="fas fa-id-card"></i>
            <span>UID: <?php echo htmlspecialchars($_SESSION['id']); ?></span>
          </div>
          <div class="profile-detail">
            <i class="fas fa-clock"></i>
            <span>Last login: <?php echo $lastLogin; ?></span>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Balance Summary -->
  <div class="balance-summary">
    <div class="balance-title">
      <h3>Total Balance</h3>
      <button class="refresh-balance" onclick="location.reload()">
        <i class="fas fa-sync-alt"></i>
      </button>
    </div>
    <div class="balance-amount" id="balance">
      ₹<?php echo htmlspecialchars(number_format($totalBalance, 2)); ?>
    </div>
    <div class="balance-actions">
      <div class="balance-action" onclick="window.location.href='/game/recharge'">
        <img src="/images/rechargeIcon.png" alt="Recharge" class="balance-icon">
        <span class="balance-label">Deposit</span>
      </div>
      <div class="balance-action" onclick="window.location.href='/withdraw.php'">
        <img src="https://bdgwin.co/assets/png/widthdrawBlue-5fcf62bd.webp" alt="Withdraw" class="balance-icon">
        <span class="balance-label">Withdraw</span>
      </div>
      <div class="balance-action" onclick="window.location.href='/vip.php'">
        <img src="/images/vip.png" alt="VIP" class="balance-icon">
        <span class="balance-label">VIP</span>
      </div>
    </div>
  </div>

  <!-- History Section START -->
  <div class="history-section">
    <div class="history-row">
      <div class="history-grid">
        <div class="history-item" onclick="window.location.href='/game/transaction'">
          <div class="history-content">
            <img src="/images/transaction.png" alt="Transaction" class="history-icon">
            <div class="history-text">
              <h4>Transaction</h4>
              <span>Transaction history</span>
            </div>
          </div>
        </div>
        <div class="history-item" onclick="window.location.href='/game/record'">
          <div class="history-content">
            <img src="/images/rechargeHistory.png" alt="Deposit" class="history-icon">
            <div class="history-text">
              <h4>Deposit</h4>
              <span>Deposit history</span>
            </div>
          </div>
        </div>
        <div class="history-item" onclick="window.location.href='/game/withdrawrec'">
          <div class="history-content">
            <img src="/images/withdrawhistory.png" alt="Withdraw" class="history-icon">
            <div class="history-text">
              <h4>Withdraw</h4>
              <span>Withdraw history</span>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <!-- History Section END -->

  <!-- Notification & Gift Section -->
  <div class="section-list">
    <div onclick="location.href='notification.php'">
      <img src="https://cdn-icons-png.flaticon.com/128/12319/12319776.png" alt="notification icon" style="width: 20px; height: 20px; margin-right: 10px;">
      <span>Notification</span>
      <i class="fas fa-angle-right"></i>
    </div>
    <div onclick="location.href='/game/gift'">
      <img src="/images/gift.png" alt="gift icon" style="width: 30px; height: 20px; margin-right: 10px;">
      <span>Gift</span>
      <i class="fas fa-angle-right"></i>
    </div>
  </div>

  <!-- Service Center -->
  <div class="service-center">
    <h4>Service Center</h4>
    <div class="service-grid">
      <div class="service-item" onclick="location.href='/game/editprofile'">
        <i class="fas fa-cog"></i>
        <br>Settings
      </div>
      <div class="service-item" onclick="location.href='/game/feedback'">
        <i class="fas fa-comment-dots"></i>
        <br>Feedback
      </div>
      <div class="service-item" onclick="location.href='/game/announcement'">
        <i class="fas fa-bullhorn"></i>
        <br>Announcement
      </div>
      <div class="service-item" onclick="location.href='/game/support'">
        <img src="/images/Customer Service.png" alt="Customer Service" style="width: 24px; height: 24px;">
        <br>Customer Service
      </div>
      <div class="service-item" onclick="location.href='/game/guide'">
        <i class="fas fa-book"></i>
        <br>Beginner's Guide
      </div>
      <div class="service-item" onclick="location.href='/game/about'">
        <i class="fas fa-cube"></i>
        <br>About Us
      </div>
    </div>
  </div>

  <button class="logout-btn" onclick="window.location.href='/game/logout'">
    <i class="fas fa-sign-out-alt"></i> Log out
  </button>
</div>

<nav class="bottom-nav">
  <a href="/home"><i class="fas fa-gamepad"></i>Games</a>
  <a href="/game/invite"><i class="fas fa-user-friends"></i>Invite</a>
  <a href="/game/wallet"><i class="fas fa-wallet"></i>Wallet</a>
  <a href="#" class="active"><i class="fas fa-user"></i>Account</a>
</nav>

<script>
  // Balance update animation
  function animateBalanceUpdate(oldVal, newVal) {
    const balanceElement = document.getElementById('balance');
    const duration = 1000;
    const start = parseFloat(oldVal.replace(/,/g, ''));
    const end = parseFloat(newVal.replace(/,/g, ''));
    const startTime = performance.now();

    function updateBalance(timestamp) {
      const progress = Math.min((timestamp - startTime) / duration, 1);
      const currentValue = start + (end - start) * progress;
      balanceElement.textContent = currentValue.toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ",");
      if (progress < 1) {
        requestAnimationFrame(updateBalance);
      }
    }
    requestAnimationFrame(updateBalance);
  }

  // Auto update balance
  setInterval(() => {
    fetch('/balance.php', { credentials: 'same-origin' })
      .then(r => r.json())
      .then(d => {
        if (d.balance !== undefined) {
          const currentBalance = document.getElementById('balance').textContent;
          const newBalance = parseFloat(d.balance).toFixed(2);
          if (currentBalance !== newBalance) {
            animateBalanceUpdate(currentBalance, newBalance);
          }
        }
      })
      .catch(err => console.error('Error fetching balance:', err));
  }, 10000);
</script>
</body>
</html>
