<?php
session_start();
$isLoggedIn = isset($_SESSION["loggedin"]) && $_SESSION["loggedin"] === true;

$balance = 0;
$bonus_percentage = 10; // Fallback default

if ($isLoggedIn) {
    require_once "../config.php";

    // Fetch bonus percentage from DB
    $stmt = $conn->prepare("SELECT bonus_percentage FROM settings LIMIT 1");
    $stmt->execute();
    $result = $stmt->get_result();
    if ($row = $result->fetch_assoc()) {
        $bonus_percentage = $row['bonus_percentage'];
    }
    $stmt->close();

    // Validate session username before querying
    if (isset($_SESSION['username']) && !empty($_SESSION['username'])) {
        $balance_query = "SELECT balance AS total FROM users WHERE username=?";
        $stmt = $conn->prepare($balance_query);
        $stmt->bind_param("s", $_SESSION['username']);
        $stmt->execute();
        $result = $stmt->get_result();
        $sum = $result->fetch_assoc();
        $balance = ($sum['total'] === null || $sum['total'] === "") ? 0 : round($sum['total'], 2);
        $stmt->close();
    } else {
        $balance = 0; // Fallback if session data is invalid
        session_destroy(); // Optional: Destroy session if username is invalid
        header("Location: /game/login");
        exit();
    }

    $conn->close();
} else {
    header("location: login");
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <title>Chicken Road - Recharge</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="icon" href="logo.png">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Poppins', sans-serif;
            background: #0c0c0f;
            color: #fff;
            overflow-x: hidden;
            padding-bottom: 100px;
        }

        /* ===== Header ===== */
        header {
            position: sticky;
            top: 0;
            z-index: 200;
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 15px 20px;
            background: rgba(25, 25, 30, 0.75);
            backdrop-filter: blur(12px);
            border-bottom: 1px solid rgba(255,255,255,0.1);
            animation: slideDown .5s ease;
        }

        @keyframes slideDown {
            from { transform: translateY(-100%); }
            to { transform: translateY(0); }
        }

        .logo {
            font-size: 1.4rem;
            font-weight: 700;
            background: linear-gradient(90deg, #ffd65a, #fbb034);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            letter-spacing: 1px;
        }

        .balance {
            background: rgba(255,215,0,0.08);
            border: 1px solid rgba(255,215,0,0.3);
            padding: 6px 14px;
            border-radius: 20px;
            font-weight: 600;
            font-size: .95rem;
            color: #ffd65a;
            display: flex;
            align-items: center;
        }

        .balance i {
            color: #ffd65a;
            margin-right: 5px;
        }

        .refresh-btn {
            background: none;
            border: none;
            color: #ffd65a;
            cursor: pointer;
            margin-left: 5px;
            font-size: 1rem;
        }

        /* ===== Recharge Section ===== */
        .recharge-box {
            background: rgba(255,255,255,0.06);
            border-radius: 16px;
            padding: 20px;
            margin: 30px 20px;
            box-shadow: 0 6px 18px rgba(0,0,0,0.3);
            backdrop-filter: blur(10px);
            animation: fadeInUp 1s ease;
        }

        .recharge-title {
            text-align: center;
            color: #ffd65a;
            font-size: 1.8rem;
            margin-bottom: 20px;
        }

        .amount-input {
            width: 100%;
            padding: 12px 20px;
            border-radius: 30px;
            border: 1px solid rgba(255,215,0,0.3);
            background: rgba(255,255,255,0.05);
            color: #fff;
            font-size: 1rem;
            outline: none;
            transition: all 0.3s ease;
            margin-bottom: 15px;
        }

        .amount-input:focus {
            border-color: #ffd65a;
            box-shadow: 0 0 10px rgba(255,215,0,0.2);
        }

        .amount-buttons {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(100px, 1fr));
            gap: 10px;
            margin: 20px 0;
        }

        .amount-btn {
            background: linear-gradient(135deg, #ffd65a, #fbb034);
            color: #111;
            padding: 10px;
            border-radius: 20px;
            font-weight: 600;
            text-align: center;
            cursor: pointer;
            transition: all 0.3s ease;
            position: relative;
        }

        .amount-btn:hover {
            background: linear-gradient(135deg, #fbb034, #e09e28);
            transform: scale(1.05);
        }

        .bonus-tag {
            position: absolute;
            top: -5px;
            right: -5px;
            background: #e09e28;
            color: #fff;
            font-size: 0.7rem;
            padding: 2px 6px;
            border-radius: 10px;
        }

        .payment-options {
            margin: 20px 0;
        }

        .payment-option {
            display: flex;
            align-items: center;
            background: rgba(255,255,255,0.04);
            padding: 12px;
            border-radius: 12px;
            margin-bottom: 10px;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .payment-option:hover {
            background: rgba(255, 215, 0, 0.08);
        }

        .payment-option input {
            margin-right: 10px;
            display: none; /* Hide the radio button, but keep functionality */
        }

        .payment-option.selected {
            border: 1px solid #ffd65a;
        }

        .recharge-btn {
            background: linear-gradient(135deg, #ffd65a, #fbb034);
            color: #111;
            padding: 12px;
            border-radius: 30px;
            font-size: 1rem;
            font-weight: 600;
            text-align: center;
            cursor: pointer;
            transition: all 0.3s ease;
            display: block;
            width: 100%;
        }

        .recharge-btn:hover {
            background: linear-gradient(135deg, #fbb034, #e09e28);
            transform: scale(1.05);
        }

        .tips-section {
            margin-top: 30px;
            background: rgba(255,255,255,0.03);
            border-radius: 16px;
            padding: 15px;
        }

        .tips-section h3 {
            color: #ffd65a;
            margin-bottom: 10px;
        }

        .tips-section ul {
            list-style-type: none;
        }

        .tips-section li {
            margin-bottom: 8px;
            font-size: 0.9rem;
        }

        /* Confirmation Popup */
        .popup {
            display: none;
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            background: rgba(25, 25, 30, 0.9);
            padding: 20px;
            border-radius: 16px;
            text-align: center;
            z-index: 300;
        }

        .popup button {
            margin: 10px;
            padding: 8px 16px;
            border-radius: 20px;
            cursor: pointer;
        }

        .confirm-btn {
            background: #ffd65a;
            color: #111;
        }

        .cancel-btn {
            background: gray;
            color: #fff;
        }

        /* History Link Button */
        .history-link {
            background: linear-gradient(135deg, #ffd65a, #fbb034);
            color: #111;
            padding: 12px 24px;
            border-radius: 30px;
            text-decoration: none;
            display: block;
            margin: 30px auto;
            max-width: 250px;
            transition: all 0.3s ease;
            text-align: center;
            font-weight: 600;
            font-size: 1rem;
            box-shadow: 0 4px 12px rgba(255, 215, 0, 0.3);
        }

        .history-link:hover {
            background: linear-gradient(135deg, #fbb034, #e09e28);
            transform: scale(1.05);
            box-shadow: 0 6px 18px rgba(255, 215, 0, 0.4);
        }

        .history-link i {
            margin-right: 8px;
        }

        /* ===== Bottom Nav ===== */
        .bottom-nav {
            position: fixed;
            bottom: 0;
            left: 0;
            width: 100%;
            height: 60px;
            backdrop-filter: blur(12px);
            background: rgba(20,20,20,0.7);
            display: flex;
            justify-content: space-around;
            align-items: center;
            border-top: 1px solid rgba(255,255,255,0.1);
            z-index: 100;
        }

        .bottom-nav a {
            flex: 1;
            text-align: center;
            color: #aaa;
            font-size: 12px;
            text-decoration: none;
            display: flex;
            flex-direction: column;
            align-items: center;
            transition: color .3s ease;
        }

        .bottom-nav a i {
            font-size: 18px;
            margin-bottom: 3px;
        }

        .bottom-nav a.active, .bottom-nav a:hover {
            color: #ffd65a;
        }

        /* Animations */
        @keyframes fadeInUp {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .recharge-box {
                margin: 20px 10px;
                padding: 15px;
            }

            .amount-buttons {
                grid-template-columns: repeat(2, 1fr);
            }

            .payment-option {
                flex-direction: column;
                align-items: flex-start;
            }
        }
    </style>
</head>
<body>
    <!-- Header -->
    <header>
        <div class="logo">Chicken Road</div>
        <div class="balance">
            <i class="fas fa-wallet"></i> ₹<span id="balance"><?php echo number_format($balance, 2); ?></span>
            <button class="refresh-btn" id="refresh-balance"><i class="fas fa-sync-alt"></i></button>
        </div>
    </header>

    <!-- Recharge Title -->
    <h2 class="recharge-title">Recharge Your Wallet</h2>

    <!-- Recharge Box -->
    <div class="recharge-box">
        <input type="number" id="amount" class="amount-input" placeholder="Enter recharge amount (min ₹500)" value="500" min="500">

        <div class="amount-buttons">
            <div class="amount-btn" data-amount="500">₹500 <span class="bonus-tag">+<?php echo $bonus_percentage; ?>%</span></div>
            <div class="amount-btn" data-amount="1000">₹1000 <span class="bonus-tag">+<?php echo $bonus_percentage; ?>%</span></div>
            <div class="amount-btn" data-amount="2000">₹2000 <span class="bonus-tag">+<?php echo $bonus_percentage; ?>%</span></div>
            <div class="amount-btn" data-amount="5000">₹5000 <span class="bonus-tag">+<?php echo $bonus_percentage; ?>%</span></div>
            <div class="amount-btn" data-amount="10000">₹10000 <span class="bonus-tag">+<?php echo $bonus_percentage; ?>%</span></div>
            <div class="amount-btn" data-amount="49999">₹49999 <span class="bonus-tag">+<?php echo $bonus_percentage; ?>%</span></div>
        </div>

        <div class="payment-options">
            <div class="payment-option" data-method="ekpay">
                <input type="radio" id="ekpay" name="payment" value="ekpay" checked>
                <label for="ekpay">EKPAY</label>
            </div>
            <div class="payment-option" data-method="payu">
                <input type="radio" id="payu" name="payment" value="payu">
                <label for="payu">PayU</label>
            </div>
            <div class="payment-option" data-method="upi">
                <input type="radio" id="upi" name="payment" value="upi">
                <label for="upi">UPI (New!)</label>
            </div>
            <div class="payment-option" data-method="card">
                <input type="radio" id="card" name="payment" value="card">
                <label for="card">Credit/Debit Card</label>
            </div>
        </div>

        <div class="recharge-btn" id="proceed">Proceed to Recharge</div>
    </div>

    <!-- Tips Section -->
    <div class="tips-section recharge-box">
        <h3>Recharge Tips</h3>
        <ul>
            <li>Minimum recharge amount is ₹500 to qualify for bonuses.</li>
            <li>Get an automatic +<?php echo $bonus_percentage; ?>% bonus on every recharge!</li>
            <li>Transactions are secure and processed instantly.</li>
            <li>Check your transaction history in the Wallet section.</li>
            <li>Recharge during promotions for even more bonuses!</li>
        </ul>
    </div>

    <!-- Improved History Link -->
    <a href="/game/record" class="history-link"><i class="fas fa-history"></i> View Recharge Records</a>

    <!-- Confirmation Popup -->
    <div id="confirm-popup" class="popup">
        <p>Pay ₹<span id="confirm-amount"></span> and get ₹<span id="confirm-total"></span> credited (including +<?php echo $bonus_percentage; ?>% bonus) using <span id="confirm-method"></span>?</p>
        <button class="confirm-btn" id="confirm-yes">Yes</button>
        <button class="cancel-btn" id="confirm-no">No</button>
    </div>

    <!-- Bottom Navigation -->
    <nav class="bottom-nav">
        <a href="/home"><i class="fas fa-gamepad"></i>Games</a>
        <a href="/game/invite"><i class="fas fa-user-friends"></i>Invite</a>
        <a href="/game/wallet" class="active"><i class="fas fa-wallet"></i>Wallet</a>
        <a href="/game/profile"><i class="fas fa-user"></i>Profile</a>
    </nav>

    <!-- Scripts -->
    <script>
    // Balance Auto Refresh (with manual button)
    function refreshBalance() {
        fetch('/balance.php')
            .then(res => res.json())
            .then(data => {
                if (data.balance !== undefined) {
                    document.getElementById('balance').textContent = data.balance;
                }
            })
            .catch(err => console.error('Balance fetch error:', err));
    }
    setInterval(refreshBalance, 10000);
    document.getElementById('refresh-balance').addEventListener('click', refreshBalance);

    // Amount Button Click Handlers
    document.querySelectorAll('.amount-btn').forEach(btn => {
        btn.addEventListener('click', () => {
            document.getElementById('amount').value = btn.dataset.amount; // Set base amount
        });
    });

    // Make entire payment option clickable
    document.querySelectorAll('.payment-option').forEach(option => {
        option.addEventListener('click', () => {
            const radio = option.querySelector('input[type="radio"]');
            radio.checked = true;
            document.querySelectorAll('.payment-option').forEach(opt => opt.classList.remove('selected'));
            option.classList.add('selected');
        });
    });

    // Proceed Button Handler with Confirmation
    document.getElementById('proceed').addEventListener('click', () => {
        const baseAmount = parseInt(document.getElementById('amount').value);
        if (isNaN(baseAmount) || baseAmount < 500) {
            alert('Please enter a valid amount (minimum ₹500).');
            return;
        }

        const bonus = (baseAmount * <?php echo $bonus_percentage; ?> / 100);
        const totalCredited = baseAmount + bonus;

        const paymentMethod = document.querySelector('input[name="payment"]:checked').value;
        document.getElementById('confirm-amount').textContent = baseAmount;
        document.getElementById('confirm-total').textContent = totalCredited.toFixed(2);
        document.getElementById('confirm-method').textContent = paymentMethod.toUpperCase();
        document.getElementById('confirm-popup').style.display = 'block';
    });

    // Confirmation Handlers
    document.getElementById('confirm-yes').addEventListener('click', () => {
        const baseAmount = parseInt(document.getElementById('confirm-amount').textContent);
        const paymentMethod = document.getElementById('confirm-method').textContent.toLowerCase();
        let payUrl = '';

        if (paymentMethod === 'ekpay') {
            payUrl = '/pay?cNiKfn72qWvERvmCI3plPoNFzw8zW01OG7SaKiPndOjk5qG2Mj=' + baseAmount;
        } else if (paymentMethod === 'payu') {
            payUrl = '/PayU/index?am=' + baseAmount;
        } else if (paymentMethod === 'upi') {
            payUrl = '/upi/pay?am=' + baseAmount; // Assuming a new UPI endpoint
        } else if (paymentMethod === 'card') {
            payUrl = '/card/pay?am=' + baseAmount; // Assuming a new card endpoint
        }

        if (payUrl) {
            window.open(payUrl, '_self');
        }
        document.getElementById('confirm-popup').style.display = 'none';
    });

    document.getElementById('confirm-no').addEventListener('click', () => {
        document.getElementById('confirm-popup').style.display = 'none';
    });
    </script>
</body>
</html>
