<?php
// Initialize the session
session_start();

// Check if the user is logged in, if not then redirect to login page
if(!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true){
    header("location: login");
    exit;
}
require_once "../config.php";

// Fetch user's balance from database
$username = $_SESSION['username'];
$stmt = $conn->prepare("SELECT balance FROM users WHERE username = ?");
$stmt->bind_param("s", $username);
$stmt->execute();
$result_balance = $stmt->get_result();
if ($row_balance = $result_balance->fetch_assoc()) {
    $balance = $row_balance['balance'] ?? 0;
} else {
    $balance = 0;
}
$stmt->close();

// Auto-delete records older than 7 days
$delete_query = "DELETE FROM `record` WHERE created_at < NOW() - INTERVAL 7 DAY";
mysqli_query($conn, $delete_query);

// Fetch records
$query = "SELECT * FROM record WHERE username = ? ORDER BY id DESC";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $_SESSION['username']);
$stmt->execute();
$result = $stmt->get_result();

$dataRow = "";
$number_of_result = $result->num_rows;
$results_per_page = 10;

// Determine the total number of pages available
$number_of_page = ceil($number_of_result / $results_per_page);

// Determine which page number visitor is currently on
$page = isset($_GET['page']) ? intval($_GET['page']) : 1;
if ($page < 1) $page = 1;
if ($page > $number_of_page) $page = $number_of_page;

// Determine the sql LIMIT starting number for the results on the displaying page
$page_first_result = ($page - 1) * $results_per_page;

// Retrieve the selected results from database
$query = "SELECT * FROM record WHERE username = ? ORDER BY id DESC LIMIT ?, ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("sii", $_SESSION['username'], $page_first_result, $results_per_page);
$stmt->execute();
$result = $stmt->get_result();

while ($row2 = $result->fetch_assoc()) {
    // Map status and color
    $status_display = $row2['status'];
    $colour = "";
    if ($row2['status'] == 'Applying') {
        $status_display = 'Pending';
        $colour = "#eaa541";
    } elseif ($row2['status'] == 'Agree') {
        $status_display = 'Processing';
        $colour = "#469491";
    } else {
        $status_display = 'Success'; // Assuming else is success
        $colour = "#96429d";
    }

    $s = ".00";
    $am = round($row2['withdraw']);
    $dataRow .= "
    <li data-v-62a71d62=''>
        <ol data-v-62a71d62=''>
            <p data-v-62a71d62=''>₹ $am $s </p>
            <p data-v-62a71d62='' style='color:$colour ;font-size:15px;'>$status_display</p>
            <!---->
            <!---->
            <!---->
        </ol>
        <ol data-v-62a71d62=''>
            <p data-v-62a71d62=''>$row2[date]</p>
            <p data-v-62a71d62='' class='times'>BankCard</p>
        </ol>
        <ol data-v-62a71d62=''>
            <p data-v-62a71d62='' class='num'>$row2[txnid]</p>
        </ol>
    </li>";
}
$stmt->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <title>Chicken Road - Withdrawal Record</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="icon" href="logo.png">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Poppins', sans-serif;
            background: #0c0c0f;
            color: #fff;
            overflow-x: hidden;
            padding-bottom: 100px;
        }

        /* ===== Header ===== */
        header {
            position: sticky;
            top: 0;
            z-index: 200;
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 15px 20px;
            background: rgba(25, 25, 30, 0.75);
            backdrop-filter: blur(12px);
            border-bottom: 1px solid rgba(255,255,255,0.1);
            animation: slideDown .5s ease;
        }

        @keyframes slideDown {
            from { transform: translateY(-100%); }
            to { transform: translateY(0); }
        }

        .logo {
            font-size: 1.4rem;
            font-weight: 700;
            background: linear-gradient(90deg, #ffd65a, #fbb034);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            letter-spacing: 1px;
        }

        .balance {
            background: rgba(255,215,0,0.08);
            border: 1px solid rgba(255,215,0,0.3);
            padding: 6px 14px;
            border-radius: 20px;
            font-weight: 600;
            font-size: .95rem;
            color: #ffd65a;
            display: flex;
            align-items: center;
        }

        .balance i {
            color: #ffd65a;
            margin-right: 5px;
        }

        /* ===== Record List ===== */
        .record-box {
            background: rgba(255,255,255,0.06);
            border-radius: 16px;
            padding: 20px;
            margin: 30px 20px;
            box-shadow: 0 6px 18px rgba(0,0,0,0.3);
            backdrop-filter: blur(10px);
            animation: fadeInUp 1s ease;
        }

        .record-title {
            text-align: center;
            color: #ffd65a;
            font-size: 1.8rem;
            margin-bottom: 20px;
        }

        .list-box {
            list-style: none;
        }

        .list-box li {
            background: rgba(255,255,255,0.04);
            padding: 15px;
            border-radius: 12px;
            margin-bottom: 10px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .list-box li ol {
            flex: 1;
        }

        .list-box li p {
            margin: 5px 0;
        }

        .empty-state {
            text-align: center;
            color: #aaa;
            font-size: 1.2rem;
            padding: 20px;
        }

        .empty-state i {
            font-size: 2rem;
            color: #ffd65a;
            margin-bottom: 10px;
        }

        .pagination {
            display: flex;
            justify-content: center;
            margin-top: 20px;
        }

        .pagination a {
            background: rgba(255,215,0,0.1);
            color: #ffd65a;
            padding: 8px 12px;
            border-radius: 20px;
            text-decoration: none;
            margin: 0 5px;
            transition: all 0.3s ease;
        }

        .pagination a:hover {
            background: #ffd65a;
            color: #111;
        }

        /* ===== Bottom Nav ===== */
        .bottom-nav {
            position: fixed;
            bottom: 0;
            left: 0;
            width: 100%;
            height: 60px;
            backdrop-filter: blur(12px);
            background: rgba(20,20,20,0.7);
            display: flex;
            justify-content: space-around;
            align-items: center;
            border-top: 1px solid rgba(255,255,255,0.1);
            z-index: 100;
        }

        .bottom-nav a {
            flex: 1;
            text-align: center;
            color: #aaa;
            font-size: 12px;
            text-decoration: none;
            display: flex;
            flex-direction: column;
            align-items: center;
            transition: color .3s ease;
        }

        .bottom-nav a i {
            font-size: 18px;
            margin-bottom: 3px;
        }

        .bottom-nav a.active, .bottom-nav a:hover {
            color: #ffd65a;
        }

        /* Animations */
        @keyframes fadeInUp {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .record-box {
                margin: 20px 10px;
                padding: 15px;
            }
            
            .record-title {
                font-size: 1.5rem;
            }
            
            .list-box li {
                flex-direction: column;
                align-items: flex-start;
            }
            
            .list-box li ol {
                width: 100%;
                margin-bottom: 10px;
            }
            
            .list-box li p {
                font-size: 0.9rem;
            }
            
            .pagination {
                flex-wrap: wrap;
            }
            
            .pagination a {
                padding: 6px 10px;
                margin: 5px;
            }
            
            .bottom-nav a {
                font-size: 10px;
            }
            
            .bottom-nav a i {
                font-size: 16px;
            }
        }
    </style>
</head>
<body>

<!-- Header -->
<header>
    <div class="logo">Chicken Road</div>
    <div class="balance">
        <i class="fas fa-wallet"></i> ₹<span id="balance"><?php echo number_format($balance, 2); ?></span>
    </div>
</header>

<!-- Record Title -->
<h2 class="record-title">Withdrawal Records</h2>

<!-- Record Box -->
<div class="record-box">
    <?php if (mysqli_num_rows($result) == 0): ?>
        <div class="empty-state">
            <i class="fas fa-info-circle"></i>
            <p>No withdrawal records found</p>
        </div>
    <?php else: ?>
        <ul class="list-box">
            <?php echo $dataRow; ?>
        </ul>
    <?php endif; ?>

    <!-- Pagination -->
    <div class="pagination">
        <?php
        if ($page == 1) {
            echo '<a href="#"><i class="fas fa-arrow-left"></i></a>';
            if ($number_of_page > 1) {
                echo '<a href="withdrawrec?page=' . ($page + 1) . '"><i class="fas fa-arrow-right"></i></a>';
            }
        } else {
            echo '<a href="withdrawrec?page=' . ($page - 1) . '"><i class="fas fa-arrow-left"></i></a>';
            if ($page < $number_of_page) {
                echo '<a href="withdrawrec?page=' . ($page + 1) . '"><i class="fas fa-arrow-right"></i></a>';
            } else {
                echo '<a href="#"><i class="fas fa-arrow-right"></i></a>';
            }
        }
        ?>
        <span>Page <?php echo $page; ?> of <?php echo $number_of_page; ?></span>
    </div>
</div>

<!-- Bottom Navigation -->
<nav class="bottom-nav">
    <a href="/game/home"><i class="fas fa-gamepad"></i>Games</a>
    <a href="/game/invite"><i class="fas fa-user-friends"></i>Invite</a>
    <a href="/game/wallet"><i class="fas fa-wallet"></i>Wallet</a>
    <a href="/game/profile"><i class="fas fa-user"></i>Profile</a>
</nav>

<!-- Scripts -->
<script>
// Balance Auto Refresh
setInterval(() => {
    fetch('/api/balance.php')
        .then(res => res.json())
        .then(data => {
            if (data.balance !== undefined) {
                document.getElementById('balance').textContent = data.balance;
            }
        })
        .catch(err => console.error('Balance fetch error:', err));
}, 10000);
</script>
</body>
</html>
