<?php
session_start();
$isLoggedIn = isset($_SESSION["loggedin"]) && $_SESSION["loggedin"] === true;

$balance = 0;

if ($isLoggedIn) {
    require_once "config.php";

    // Function to fetch single value from database
    function fetchSum($conn, $query, $params) {
        $stmt = $conn->prepare($query);
        if ($stmt === false) return 0;

        $types = str_repeat('s', count($params));
        $stmt->bind_param($types, ...$params);
        $stmt->execute();
        $result = $stmt->get_result();
        $sum = $result->fetch_assoc();
        $stmt->close();

        return ($sum['total'] === null || $sum['total'] === "") ? 0 : round($sum['total'], 2);
    }

    // Validate session username before querying
    if (isset($_SESSION['username']) && !empty($_SESSION['username'])) {
        $balance = fetchSum($conn, "SELECT balance AS total FROM users WHERE username=?", [$_SESSION['username']]);
    } else {
        $balance = 0;
        session_destroy();
        header("Location: /game/login");
        exit();
    }

    $conn->close();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <title>Chicken Road - Games</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <style>
        /* ===== Global Styles ===== */
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Poppins', sans-serif;
            background: #0c0c0f;
            color: #fff;
            overflow-x: hidden;
            padding-bottom: 100px;
        }

        /* ===== Header ===== */
        header {
            position: sticky;
            top: 0;
            z-index: 200;
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 15px 20px;
            background: rgba(25, 25, 30, 0.75);
            backdrop-filter: blur(12px);
            border-bottom: 1px solid rgba(255,255,255,0.1);
            animation: slideDown .5s ease;
        }
        @keyframes slideDown {
            from { transform: translateY(-100%); }
            to { transform: translateY(0); }
        }
        .logo {
            font-size: 1.4rem;
            font-weight: 700;
            background: linear-gradient(90deg, #ffd65a, #fbb034);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            letter-spacing: 1px;
        }
        .auth-buttons, .balance {
            display: flex;
            gap: 10px;
            align-items: center;
        }
        .auth-buttons a {
            padding: 6px 14px;
            border-radius: 20px;
            background: rgba(255,215,0,0.1);
            color: #ffd65a;
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        .auth-buttons a:hover {
            background: #ffd65a;
            color: #111;
        }
        .balance {
            background: rgba(255,215,0,0.08);
            border: 1px solid rgba(255,215,0,0.3);
            padding: 6px 14px;
            border-radius: 20px;
            font-weight: 600;
            font-size: .95rem;
            color: #ffd65a;
        }

        /* ===== Banner ===== */
        .banner-container { position: relative; height: 200px; overflow: hidden; margin: 0; }
        .banner-slide {
            position: absolute; top: 0; left: 0; width: 100%; height: 100%;
            opacity: 0; transition: opacity 1s ease-in-out;
        }
        .banner-slide.active { opacity: 1; }
        .banner-slide img { width: 100%; height: 100%; object-fit: cover; display: block; }
        .banner-content {
            position: absolute; bottom: 20px; left: 20px; right: 20px;
            background: rgba(0, 0, 0, 0.6); padding: 15px 20px; border-radius: 12px;
            backdrop-filter: blur(10px);
        }
        .banner-title { font-size: 1.3rem; font-weight: 700; color: #ffd65a; margin-bottom: 5px; }
        .banner-description { font-size: 0.9rem; color: #fff; line-height: 1.4; }
        .banner-indicators {
            position: absolute; bottom: 10px; right: 20px; display: flex; gap: 8px;
        }
        .indicator {
            width: 8px; height: 8px; border-radius: 50%;
            background: rgba(255, 255, 255, 0.5); cursor: pointer; transition: all 0.3s ease;
        }
        .indicator.active { background: #ffd65a; transform: scale(1.2); }

        /* ===== Quick Actions ===== */
        .quick-actions {
            display: flex; justify-content: space-around; padding: 15px 20px;
            background: rgba(255, 255, 255, 0.03); gap: 10px;
        }
        .quick-action {
            display: flex; flex-direction: column; align-items: center;
            color: #fff; text-decoration: none; padding: 10px; border-radius: 12px;
            flex: 1; max-width: 80px; transition: all 0.3s ease;
        }
        .quick-action:hover {
            background: rgba(255, 215, 0, 0.1); transform: translateY(-3px);
        }
        .quick-action i { font-size: 1.5rem; color: #ffd65a; margin-bottom: 5px; }
        .quick-action span { font-size: 0.7rem; font-weight: 600; text-align: center; }

        /* ===== Search ===== */
        .search-container { max-width: 600px; margin: 20px auto; padding: 0 20px; }
        .search-input {
            width: 100%; padding: 12px 20px; border-radius: 30px;
            border: 1px solid rgba(255,215,0,0.3); background: rgba(255,255,255,0.05);
            color: #fff; font-size: 1rem; outline: none; transition: all 0.3s ease;
        }
        .search-input:focus { border-color: #ffd65a; box-shadow: 0 0 10px rgba(255,215,0,0.2); }

        /* ===== Games ===== */
        .game-title {
            text-align: center; color: #ffd65a; font-size: 1.8rem;
            margin: 30px 20px 20px; position: relative;
        }
        .game-title::after {
            content: ''; position: absolute; bottom: -5px; left: 50%;
            transform: translateX(-50%); width: 60px; height: 3px;
            background: linear-gradient(90deg, #ffd65a, #fbb034); border-radius: 2px;
        }
        .game-section {
            display: grid; grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
            gap: 18px; padding: 20px;
        }
        .game-box {
            background: rgba(255,255,255,0.06);
            border-radius: 16px;
            padding: 12px;
            text-align: center;
            box-shadow: inset 0 1px 0 rgba(255,255,255,0.1), 0 6px 18px rgba(0,0,0,0.3);
            backdrop-filter: blur(8px);
            transition: transform .3s ease, box-shadow .3s ease;
            animation: fadeInUp 0.7s ease;
            position: relative;
            overflow: hidden;
        }
        .game-box::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,215,0,0.1), transparent);
            transition: left 0.6s ease;
        }
        .game-box:hover::before {
            left: 100%;
        }

        .game-box:hover {
            transform: translateY(-6px) scale(1.02);
            box-shadow: 0 10px 20px rgba(255,255,255,0.1);
        }
        .game-box img { width: 100%; height: 200px; border-radius: 12px; object-fit: cover; margin-bottom: 12px; }
        .game-name { font-size: 1rem; font-weight: 500; margin-bottom: 8px; }
        .play-btn {
            background: linear-gradient(135deg, #ffd65a, #fbb034); color: #111;
            padding: 12px 28px; border-radius: 30px; font-weight: 600; text-decoration: none;
            display: inline-block; transition: all .3s ease; position: relative; overflow: hidden;
        }
        .play-btn:hover {
            background: linear-gradient(135deg, #fbb034, #e09e28);
            transform: translateY(-3px) scale(1.05);
            box-shadow: 0 8px 20px rgba(247,183,49,0.4);
        }

        /* ===== Ticker ===== */
        .ticker {
            background: rgba(255,215,0,0.08); padding: 10px; margin: 20px;
            border-radius: 12px; overflow: hidden; white-space: nowrap;
        }
        .ticker-content {
            display: inline-block; animation: scroll 25s linear infinite; padding-left: 50px;
        }
        @keyframes scroll {
            0% { transform: translateX(100%); }
            100% { transform: translateX(-100%); }
        }
        .ticker-item { display: inline-block; margin-right: 40px; color: #ffd65a; font-weight: 600; }

        /* ===== Challenges / Bonuses / Tips ===== */
        .challenges, .bonuses, .tips {
            background: rgba(255, 255, 255, 0.03); margin: 30px 20px; border-radius: 16px;
            padding: 20px; box-shadow: 0 6px 18px rgba(0, 0, 0, 0.3);
            border: 1px solid rgba(255, 215, 0, 0.1);
        }
        .challenges-list, .bonuses-list {
            display: flex; flex-direction: column; gap: 15px;
        }
        .challenge-item, .bonus-item {
            display: flex; justify-content: space-between; align-items: center;
            background: rgba(255, 255, 255, 0.04); padding: 12px 15px; border-radius: 12px;
            border-left: 3px solid #ffd65a;
        }
        .bonus-item { display: none; }
        .bonus-item.active { display: flex; }
        .challenge-desc, .bonus-desc { flex: 1; font-weight: 500; color: #fff; }
        .challenge-reward, .bonus-value { font-weight: 600; color: #ffd65a; margin-right: 15px; }
        .progress-container {
            width: 100px; height: 10px; background: rgba(255,255,255,0.1);
            border-radius: 5px; overflow: hidden;
        }
        .progress-bar {
            height: 100%; background: linear-gradient(90deg, #ffd65a, #fbb034);
            width: 0%; transition: width 0.3s ease;
        }
        .claim-btn {
            background: linear-gradient(135deg, #ffd65a, #fbb034); color: #111;
            padding: 8px 16px; border-radius: 20px; font-size: 0.9rem; font-weight: 600;
            border: none; cursor: pointer; transition: all 0.3s ease;
        }
        .claim-btn.disabled, .claim-btn.ineligible {
            background: #555 !important; color: #bbb; cursor: not-allowed;
        }
        .claim-btn.eligible {
            background: linear-gradient(135deg, #ffd65a, #fbb034) !important;
        }

        /* ===== Quick Tips Section ===== */
        .tips {
            background: rgba(255, 255, 255, 0.03);
            border-radius: 16px;
            padding: 20px;
            margin: 30px 20px;
            box-shadow: 0 6px 18px rgba(0, 0, 0, 0.3);
            backdrop-filter: blur(10px);
            animation: fadeInUp 1s ease;
        }

        .tips-list {
            list-style-type: none;
            display: flex;
            flex-direction: column;
            gap: 10px;
        }

        .tip-item {
            background: rgba(255, 255, 255, 0.04);
            padding: 10px 15px;
            border-radius: 8px;
            font-size: 0.95rem;
            transition: background 0.3s ease;
        }

        .tip-item:hover {
            background: rgba(255, 215, 0, 0.08);
        }

        /* ===== Footer and Bottom Nav ===== */
        footer {
            background: #111;
            padding: 20px;
            text-align: center;
        }

        footer p {
            color: #777;
            font-size: .8rem;
        }

        .bottom-nav {
            position: fixed;
            bottom: 0;
            left: 0;
            width: 100%;
            height: 60px;
            backdrop-filter: blur(12px);
            background: rgba(20,20,20,0.7);
            display: flex;
            justify-content: space-around;
            align-items: center;
            border-top: 1px solid rgba(255,255,255,0.1);
            z-index: 100;
        }

        .bottom-nav a {
            flex: 1;
            text-align: center;
            color: #aaa;
            font-size: 12px;
            text-decoration: none;
            display: flex;
            flex-direction: column;
            align-items: center;
            transition: color .3s ease;
        }

        .bottom-nav a i {
            font-size: 18px;
            margin-bottom: 3px;
        }

        .bottom-nav a.active, .bottom-nav a:hover {
            color: #ffd65a;
        }
        /* Popup Modal */
        .modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.7);
            align-items: center;
            justify-content: center;
        }

        .modal-content {
            background: #1a1a1a;
            padding: 20px;
            border-radius: 12px;
            text-align: center;
            max-width: 300px;
            animation: fadeIn 0.3s ease;
        }

        .modal-content p {
            margin-bottom: 15px;
            font-size: 1rem;
        }

        .modal-close {
            background: #ffd65a;
            color: #111;
            padding: 8px 16px;
            border-radius: 20px;
            border: none;
            cursor: pointer;
        }

        /* Animations */
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }

        @keyframes fadeInUp {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        /* ===== Responsive ===== */
        @media (max-width: 768px) {
            .game-section { grid-template-columns: repeat(auto-fit, minmax(160px, 1fr)); }
            .challenge-item, .bonus-item { flex-direction: column; align-items: flex-start; gap: 10px; }
        }
    </style>
</head>
<body>

<!-- Header -->
<header>
    <div class="logo">Chicken Road</div>
    <?php if ($isLoggedIn): ?>
        <div class="balance">
            <i class="fas fa-wallet"></i> ₹<span id="balance"><?php echo number_format($balance, 2); ?></span>
        </div>
    <?php else: ?>
        <div class="auth-buttons">
            <a href="/game/login">Login</a>
            <a href="/game/register">Register</a>
        </div>
    <?php endif; ?>
</header>

<!-- Banner -->
<div class="banner-container">
    <div class="banner-slider" id="bannerSlider">
        <div class="banner-slide active">
            <img src="/images/b1.gif" alt="Welcome Bonus">
            <div class="banner-content">
            </div>
        </div>
        <div class="banner-slide">
            <img src="/images/b2.gif" alt="Daily Challenges">
            <div class="banner-content">
            </div>
        </div>
        <div class="banner-slide">
            <img src="/images/b3.gif" alt="VIP Program">
            <div class="banner-content">
            </div>
        </div>
    </div>
    <div class="banner-indicators" id="bannerIndicators">
        <span class="indicator active" data-slide="0"></span>
        <span class="indicator" data-slide="1"></span>
        <span class="indicator" data-slide="2"></span>
        <span class="indicator" data-slide="3"></span>
    </div>
</div>

<!-- Quick Actions -->
<div class="quick-actions">
    <a href="/game/recharge" class="quick-action"><img src="/images/rechargeIcon.png"style="width: 32px; height: 32px;"></i><span>Deposit</span></a>
    <a href="/game/withdraw" class="quick-action"><img src="https://bdgwin.co/assets/png/widthdrawBlue-5fcf62bd.webp"style="width: 32px; height: 32px;"><span>Withdraw</span></a>
    <a href="/game/invite" class="quick-action"><i class="fas fa-user-friends"></i><span>Invite</span></a>
    <a href="/game/support" class="quick-action"><i class="fas fa-headset"></i><span>Support</span></a>
</div>

<!-- Games -->
<h2 class="game-title">🎮 Play & Win</h2>
<div class="search-container">
    <input type="text" id="game-search" class="search-input" placeholder="🔍 Search games...">
</div>
<section class="game-section" id="game-section">
    <div class="game-box">
        <img src="/images/chicken_road.png" alt="Chicken Road">
        <div class="game-name">Chicken Road</div>
        <a href="/api/chicken_road.php" class="play-btn">Play Now</a>
    </div>
    <div class="game-box">
        <img src="/images/chicken_road_2.png" alt="Chicken Road 2">
        <div class="game-name">Chicken Road 2</div>
        <a href="/api/chicken_road_2.php" class="play-btn">Play Now</a>
    </div>
    <div class="game-box">
        <img src="/images/penality.png" alt="Penalty Shootout">
        <div class="game-name">Penalty Shootout</div>
        <a href="/api/penalty.php" class="play-btn">Play Now</a>
    </div>
    <div class="game-box">
        <img src="/images/aviator.png" alt="Aviator">
        <div class="game-name">Aviator</div>
        <a href="/api/aviator.php" class="play-btn">Play Now</a>
    </div>
</section>

<!-- Daily Challenges -->
<h2 class="game-title">📅 Daily Challenges</h2>
<div class="challenges">
    <div class="challenges-list">
        <div class="challenge-item">
            <span class="challenge-desc">Play any game for 10 minutes</span>
            <div class="progress-container">
                <div class="progress-bar" id="play-progress"></div>
            </div>
            <span class="challenge-reward">₹50 Bonus</span>
            <button class="claim-btn ineligible" data-type="challenge" data-id="1">Claim</button>
        </div>
        <div class="challenge-item">
            <span class="challenge-desc">Win 3 consecutive games</span>
            <div class="progress-container">
                <div class="progress-bar" id="win-streak-progress"></div>
            </div>
            <span class="challenge-reward">₹100 Bonus</span>
            <button class="claim-btn ineligible" data-type="challenge" data-id="2">Claim</button>
        </div>
        <div class="challenge-item">
            <span class="challenge-desc">Deposit ₹500 or more</span>
            <div class="progress-container">
                <div class="progress-bar" id="deposit-progress"></div>
            </div>
            <span class="challenge-reward">₹75 Bonus</span>
            <button class="claim-btn ineligible" data-type="challenge" data-id="3">Claim</button>
        </div>
    </div>
</div>

<!-- Bonus Offers -->
<h2 class="game-title">💥 Bonus Offers</h2>
<div class="bonuses">
    <div class="bonuses-list">
        <div class="bonus-item active">
            <span class="bonus-desc">First-time deposit bonus</span>
            <span class="bonus-value">+₹500</span>
            <button class="claim-btn eligible" data-type="bonus" data-id="1">Claim</button>
        </div>
        <div class="bonus-item active">
            <span class="bonus-desc">Weekly cashback 5%</span>
            <span class="bonus-value">Up to ₹1,000</span>
            <button class="claim-btn eligible" data-type="bonus" data-id="2">Claim</button>
        </div>
    </div>
</div>

<!-- Quick Tips Section -->
<h2 class="game-title">💡 Quick Tips</h2>
<div class="tips">
    <ul class="tips-list">
        <li class="tip-item">Set a budget before playing to manage your spending wisely.</li>
        <li class="tip-item">Try demo modes first to learn game mechanics without risking money.</li>
        <li class="tip-item">Check daily challenges regularly for easy bonuses.</li>
        <li class="tip-item">Invite friends to earn referral rewards and play together.</li>
        <!-- Add more tips as needed -->
    </ul>
</div>

<!-- Footer -->
<footer>
    <p>&copy; <?php echo date("Y"); ?> Chicken Road. All rights reserved.</p>
</footer>

<!-- Bottom Navigation -->
<nav class="bottom-nav">
    <a href="/home" class="active"><i class="fas fa-gamepad"></i>Games</a>
    <a href="/game/invite"><i class="fas fa-user-friends"></i>Invite</a>
    <a href="/game/wallet"><i class="fas fa-wallet"></i>Wallet</a>
    <a href="/game/profile"><i class="fas fa-user"></i>Profile</a>
</nav>

<!-- Scripts -->
<script>
/* ===== Banner Slider ===== */
let currentSlide = 0;
const slides = document.querySelectorAll('.banner-slide');
const indicators = document.querySelectorAll('.indicator');

function showSlide(index) {
    slides.forEach((s, i) => s.classList.toggle('active', i === index));
    indicators.forEach((d, i) => d.classList.toggle('active', i === index));
}
function nextSlide() {
    currentSlide = (currentSlide + 1) % slides.length;
    showSlide(currentSlide);
}
indicators.forEach(dot => {
    dot.addEventListener('click', () => {
        currentSlide = parseInt(dot.dataset.slide);
        showSlide(currentSlide);
    });
});
setInterval(nextSlide, 4000);

/* ===== Challenge Progress Bars (demo) ===== */
function updateProgress(id, percent) {
    const bar = document.getElementById(id);
    if (bar) bar.style.width = percent + '%';
}
window.addEventListener('DOMContentLoaded', () => {
    updateProgress('play-progress', 60);
    updateProgress('win-streak-progress', 33);
    updateProgress('deposit-progress', 0);
});
// Popup Functions
const modal = document.getElementById('popup-modal');
const modalMessage = document.getElementById('popup-message');
const closeBtn = document.querySelector('.modal-close');

closeBtn.addEventListener('click', () => {
    modal.style.display = 'none';
});

function showPopup(message) {
    modalMessage.textContent = message;
    modal.style.display = 'flex';
}

// Check eligibility on page load and update buttons
document.querySelectorAll('.claim-btn').forEach(btn => {
    const type = btn.dataset.type;
    const id = btn.dataset.id;
    if (type && id) {
        fetch(`/api/check_eligibility.php?type=${type}&id=${id}`)
            .then(res => res.json())
            .then(data => {
                if (data.eligible) {
                    btn.classList.remove('ineligible');
                    btn.classList.add('eligible');
                } else if (data.claimed) {
                    btn.textContent = 'Claimed';
                    btn.classList.add('disabled');
                    if (type === 'bonus') {
                        unlockNextBonus(id);
                    }
                }
            })
            .catch(err => console.error('Eligibility check error:', err));
    }
});

// Handle clicks with AJAX
document.querySelectorAll('.claim-btn').forEach(btn => {
    btn.addEventListener('click', function(e) {
        if (this.classList.contains('disabled') || this.classList.contains('ineligible')) {
            showPopup('Please complete the criteria first before claiming.');
            return;
        }

        const type = this.dataset.type;
        const id = this.dataset.id;
        fetch(`/api/claim_${type}.php?id=${id}`)
            .then(res => res.json())
            .then(data => {
                showPopup(data.message); // Shows "Claim successful!" or error
                if (data.success) {
                    this.textContent = 'Claimed';
                    this.classList.add('disabled');
                    this.classList.remove('eligible');
                    if (type === 'bonus') {
                        unlockNextBonus(id);
                    }
                }
            })
            .catch(err => {
                console.error('Claim error:', err);
                showPopup('An error occurred. Please try again.');
            });
    });
});

// Function to unlock next bonus
function unlockNextBonus(currentId) {
    const nextId = parseInt(currentId) + 1;
    const nextBonus = document.querySelector(`.bonus-item[data-bonus-id="${nextId}"]`);
    if (nextBonus) {
        nextBonus.classList.add('active');
    }
}

// Progressive Bonus Reveal (show first one initially)
document.querySelector('.bonus-item[data-bonus-id="1"]').classList.add('active');

// Balance Auto Refresh
<?php if ($isLoggedIn): ?>
setInterval(() => {
    fetch('/game/balance')
        .then(res => res.json())
        .then(data => {
            if (data.balance !== undefined) {
                document.getElementById('balance').textContent = data.balance;
            }
        })
        .catch(err => console.error('Balance fetch error:', err));
}, 10000);
<?php endif; ?>

// Game Search Functionality
document.getElementById('game-search').addEventListener('input', function() {
    const filter = this.value.toLowerCase();
    const games = document.querySelectorAll('.game-box');
    games.forEach(game => {
        const name = game.querySelector('.game-name').textContent.toLowerCase();
        game.classList.toggle('hidden', !name.includes(filter));
    });
});

// Simulate Play Time Progress (for demo; in real, fetch from server)
let playTime = 0; // in seconds
const totalTime = 600; // 10 minutes in seconds
const progressBar = document.getElementById('play-progress');
const challengeBtn = document.querySelector('.challenge-item .claim-btn[data-id="1"]');

// Simulate play time increasing when a game is "played" (trigger on play button click for demo)
document.querySelectorAll('.play-btn').forEach(btn => {
    btn.addEventListener('click', () => {
        // Start timer simulation
        const timer = setInterval(() => {
            playTime += 1;
            const progress = (playTime / totalTime) * 100;
            progressBar.style.width = `${progress}%`;
            
            if (playTime >= totalTime) {
                clearInterval(timer);
                challengeBtn.classList.remove('ineligible');
                challengeBtn.classList.add('eligible');
                showPopup('Challenge complete! You can now claim your reward.');
            }
        }, 1000); // Increment every second for demo
    });
});
</script>

</body>
</html>